/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.importer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.language.csharp.importer.CSModeller;
import org.argouml.language.csharp.importer.csparser.collections.TokenCollection;
import org.argouml.language.csharp.importer.csparser.main.FeatureNotSupportedException;
import org.argouml.language.csharp.importer.csparser.main.Lexer;
import org.argouml.language.csharp.importer.csparser.main.Parser;
import org.argouml.language.csharp.importer.csparser.structural.CompilationUnitNode;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.FileImportUtils;
import org.argouml.uml.reveng.ImportInterface;
import org.argouml.uml.reveng.ImportSettings;
import org.argouml.uml.reveng.ImporterManager;
import org.argouml.util.SuffixFilter;

public class CSharpImport
implements ImportInterface {
    private static final Logger LOG = Logger.getLogger(CSharpImport.class);
    private Collection newElements;
    private List parsedElements = new ArrayList();
    public static final SuffixFilter CS_FILE_FILTER = new SuffixFilter("cs", "CSharp");

    public Collection parseFiles(Project p, Collection files, ImportSettings settings, ProgressMonitor monitor) throws ImportInterface.ImportException {
        this.newElements = new HashSet();
        this.parsedElements = new ArrayList();
        monitor.updateMainTask(Translator.localize((String)"dialog.import.pass1"));
        monitor.setMaximumProgress(files.size() * 3);
        this.doImportPass(p, files, settings, monitor, 0, 0);
        this.parseElements(p, settings, monitor, files.size(), 1);
        monitor.close();
        return this.newElements;
    }

    private void doImportPass(Project p, Collection files, ImportSettings settings, ProgressMonitor monitor, int startCount, int pass) throws ImportInterface.ImportException {
        int count = startCount;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            if (monitor.isCanceled()) {
                monitor.updateSubTask(Translator.localize((String)"dialog.import.cancelled"));
                return;
            }
            Object file = it.next();
            if (file instanceof File) {
                System.out.println(((File)file).getAbsolutePath());
                this.parseFile(p, (File)file, settings, pass);
                monitor.updateProgress(count++);
                monitor.updateSubTask(Translator.localize((String)"dialog.import.parsingAction", (Object[])new Object[]{((File)file).getAbsolutePath()}));
                continue;
            }
            throw new ImportInterface.ImportException("Object isn't a file " + file);
        }
    }

    private void parseElements(Project p, ImportSettings settings, ProgressMonitor monitor, int startCount, int pass) throws ImportInterface.ImportException {
        CSModeller cm = new CSModeller(p, settings);
        cm.model(this.parsedElements, monitor, startCount);
        this.newElements.addAll(cm.getNewElements());
    }

    private void parseFile(Project p, File f, ImportSettings settings, int pass) throws ImportInterface.ImportException {
        try {
            BufferedInputStream bs = new BufferedInputStream(new FileInputStream(f));
            Lexer l = new Lexer(bs, f.getAbsolutePath());
            TokenCollection toks = l.lex();
            Parser px = new Parser();
            CompilationUnitNode cu = px.parse(toks, l.StringLiterals);
            this.parsedElements.add(cu);
        }
        catch (FeatureNotSupportedException e) {
            System.out.println("Error parsing file: " + f.getAbsolutePath() + " due to: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("Error parsing file: " + f.getAbsolutePath());
        }
    }

    public SuffixFilter[] getSuffixFilters() {
        SuffixFilter[] result = new SuffixFilter[]{CS_FILE_FILTER};
        return result;
    }

    public boolean isParseable(File file) {
        return FileImportUtils.matchesSuffix((Object)file, (SuffixFilter[])this.getSuffixFilters());
    }

    public String getName() {
        return " CSharp";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "This is a module for import from CSharp files.";
            }
            case 1: {
                return "Thilina Hasantha";
            }
            case 2: {
                return "1.0";
            }
        }
        return null;
    }

    public boolean disable() {
        return false;
    }

    public boolean enable() {
        this.init();
        return true;
    }

    public void init() {
        ImporterManager.getInstance().addImporter((ImportInterface)this);
    }

    public List getImportSettings() {
        return null;
    }
}

