/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import java.util.List;
import org.argouml.model.euml.ModelEventPumpEUMLImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class RootContainerAdapter
extends EContentAdapter {
    private List<Notifier> notifiers = new ArrayList<Notifier>();
    private List<Notification> events = new ArrayList<Notification>();
    private Notifier rootContainer;
    private ModelEventPumpEUMLImpl pump;
    private boolean deliverEvents = true;
    private boolean holdEvents = false;

    public RootContainerAdapter(ModelEventPumpEUMLImpl pump) {
        this.pump = pump;
    }

    public void setDeliverEvents(boolean value) {
        this.deliverEvents = value;
    }

    public void setRootContainer(Notifier n) {
        if (n == this.rootContainer) {
            return;
        }
        this.removeAllAdapters();
        if (n != null) {
            this.rootContainer = n;
            this.rootContainer.eAdapters().add((Object)this);
        }
    }

    protected void addAdapter(Notifier notifier) {
        this.notifiers.add(notifier);
        super.addAdapter(notifier);
    }

    protected void removeAdapter(Notifier notifier) {
        this.notifiers.remove(notifier);
        super.removeAdapter(notifier);
    }

    public void removeAllAdapters() {
        ArrayList<Notifier> notifiersToRemove = new ArrayList<Notifier>(this.notifiers);
        for (Notifier n : notifiersToRemove) {
            super.removeAdapter(n);
        }
        if (this.rootContainer != null) {
            super.removeAdapter(this.rootContainer);
            this.rootContainer = null;
        }
        this.notifiers.clear();
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (this.deliverEvents) {
            if (this.holdEvents) {
                this.events.add(notification);
            } else {
                this.pump.notifyChanged(notification);
            }
        }
    }

    public void clearHeldEvents() {
        this.events.clear();
    }

    public void setHoldEvents(boolean value) {
        if (!value) {
            if (this.deliverEvents) {
                for (Notification n : this.events) {
                    this.pump.notifyChanged(n);
                }
            }
            this.events.clear();
        }
        this.holdEvents = value;
    }
}

