/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.graph.MutableGraphSupport;

public class CmdNudge
extends Cmd {
    private static final long serialVersionUID = 258695407526065145L;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int UP = 3;
    public static final int DOWN = 4;
    private int _direction;
    private int _magnitude;

    public CmdNudge(int dir) {
        this(dir, 1);
    }

    public CmdNudge(int dir, int mag) {
        super("Nudge" + CmdNudge.wordFor(dir));
        this._direction = dir;
        this._magnitude = mag;
    }

    protected static String wordFor(int d) {
        switch (d) {
            case 1: {
                return "Left";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Up";
            }
            case 4: {
                return "Down";
            }
        }
        return "";
    }

    public void doIt() {
        Editor ce = Globals.curEditor();
        SelectionManager sm = ce.getSelectionManager();
        if (sm.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            return;
        }
        int dx = 0;
        int dy = 0;
        switch (this._direction) {
            case 1: {
                dx = 0 - this._magnitude;
                break;
            }
            case 2: {
                dx = this._magnitude;
                break;
            }
            case 3: {
                dy = 0 - this._magnitude;
                break;
            }
            case 4: {
                dy = this._magnitude;
            }
        }
        sm.translate(dx, dy);
        MutableGraphSupport.enableSaveAction();
        sm.endTrans();
    }

    public void undoIt() {
        System.out.println("Cannot undo CmdNudge, yet.");
    }
}

