/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public abstract class Selection
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final int HAND_SIZE = 6;
    public static final int BORDER_WIDTH = 4;
    private Fig content;

    public Selection(Fig f) {
        if (null == f) {
            throw new IllegalArgumentException("Cannot place a null Fig inside a Selection");
        }
        if (!f.isSelectable()) {
            throw new IllegalArgumentException("The given Fig cannot be selected");
        }
        this.content = f;
    }

    public Fig getContent() {
        return this.content;
    }

    public void setContent(Fig f) {
        this.content = f;
    }

    public boolean getLocked() {
        return this.getContent().getLocked();
    }

    public boolean contains(Fig f) {
        return f == this.content;
    }

    public void print(Graphics g) {
    }

    public void paint(Graphics g) {
    }

    public void endTrans() {
        this.getContent().endTrans();
    }

    public Point getLocation() {
        return this.content.getLocation();
    }

    public void damage() {
        this.content.damage();
    }

    public final boolean contains(Point pnt) {
        return this.contains(pnt.x, pnt.y);
    }

    public boolean contains(int x, int y) {
        if (this.content.contains(x, y)) {
            return true;
        }
        Handle h = new Handle(-1);
        this.hitHandle(x, y, 0, 0, h);
        return h.index != -1;
    }

    public boolean hit(Rectangle r) {
        if (this.content.hit(r)) {
            return true;
        }
        Handle h = new Handle(-1);
        this.hitHandle(r, h);
        return h.index != -1;
    }

    public abstract void hitHandle(Rectangle var1, Handle var2);

    public final void hitHandle(int x, int y, int w, int h, Handle hdl) {
        this.hitHandle(new Rectangle(x, y, w, h), hdl);
    }

    public void reorder(int func, Layer lay) {
        lay.reorder(this.content, func);
    }

    public void translate(int dx, int dy) {
        this.content.translate(dx, dy);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.content.getX() - 3, this.content.getY() - 3, this.content.getWidth() + 6, this.content.getHeight() + 6);
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            return this.getBounds();
        }
        r.setBounds(this.content.getX() - 3, this.content.getY() - 3, this.content.getWidth() + 6, this.content.getHeight() + 6);
        return r;
    }

    public void delete() {
        this.content.removeFromDiagram();
    }

    public void dispose() {
        this.content.deleteFromModel();
    }

    public abstract void dragHandle(int var1, int var2, int var3, int var4, Handle var5);

    public Rectangle getContentBounds() {
        return this.content.getBounds();
    }

    public void keyTyped(KeyEvent ke) {
        if (this.content instanceof KeyListener) {
            ((KeyListener)((Object)this.content)).keyTyped(ke);
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (this.content instanceof KeyListener) {
            ((KeyListener)((Object)this.content)).keyPressed(ke);
        }
    }

    public void keyReleased(KeyEvent ke) {
        if (this.content instanceof KeyListener) {
            ((KeyListener)((Object)this.content)).keyReleased(ke);
        }
    }

    public void mouseMoved(MouseEvent me) {
        if (this.content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.content)).mouseMoved(me);
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (this.content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this.content)).mouseDragged(me);
        }
    }

    public void mousePressed(MouseEvent me) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mousePressed(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseReleased(me);
        }
    }

    public void mouseClicked(MouseEvent me) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseClicked(me);
        }
    }

    public void mouseEntered(MouseEvent me) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseEntered(me);
        }
    }

    public void mouseExited(MouseEvent me) {
        if (this.content instanceof MouseListener) {
            ((MouseListener)((Object)this.content)).mouseExited(me);
        }
    }
}

