/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Localizer;

public class ZoomAction
extends AbstractAction {
    private static final long serialVersionUID = -952853421722122499L;
    private double _magnitude;

    public ZoomAction() {
        this(0.0);
    }

    public ZoomAction(double magnitude) {
        super(ZoomAction.wordFor(magnitude));
        this._magnitude = magnitude;
    }

    protected static String wordFor(double magnitude) {
        if (magnitude < 0.0) {
            throw new IllegalArgumentException("Zoom magnitude cannot be less than 0");
        }
        if (magnitude == 0.0) {
            return Localizer.localize("GefBase", "ZoomReset");
        }
        if (magnitude > 1.0) {
            return Localizer.localize("GefBase", "ZoomIn");
        }
        if (magnitude < 1.0) {
            return Localizer.localize("GefBase", "ZoomOut");
        }
        return Localizer.localize("GefBase", "DoNothing");
    }

    public void actionPerformed(ActionEvent e) {
        Editor ed = Globals.curEditor();
        if (ed == null) {
            return;
        }
        if (this._magnitude > 0.0) {
            ed.setScale(ed.getScale() * this._magnitude);
        } else {
            ed.setScale(1.0);
        }
        ed.damageAll();
    }
}

