/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.persistence.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAXParserBase
extends DefaultHandler {
    private static final String RETURNSTRING = "\n      ";
    protected static final boolean DBG = false;
    private XMLElement[] elements = new XMLElement[100];
    private int nElements = 0;
    private XMLElement[] freeElements = new XMLElement[100];
    private int nFreeElements = 0;
    private boolean stats = true;
    private long parseTime = 0L;
    private static Log LOG = LogFactory.getLog(SAXParserBase.class);

    public void setStats(boolean s) {
        this.stats = s;
    }

    public boolean getStats() {
        return this.stats;
    }

    public long getParseTime() {
        return this.parseTime;
    }

    public void parse(InputStream is) throws SAXException {
        long end;
        long start;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            SAXParser parser = factory.newSAXParser();
            InputSource input = new InputSource(is);
            input.setSystemId(this.getJarResource("org.argouml.kernel.Project"));
            start = System.currentTimeMillis();
            parser.parse(input, (DefaultHandler)this);
            end = System.currentTimeMillis();
            this.parseTime = end - start;
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        if (this.stats && LOG.isInfoEnabled()) {
            LOG.info((Object)("Elapsed time: " + (end - start) + " ms"));
        }
    }

    protected abstract void handleStartElement(XMLElement var1) throws SAXException;

    protected abstract void handleEndElement(XMLElement var1) throws SAXException;

    public void startElement(String uri, String localname, String name, Attributes atts) throws SAXException {
        if (this.isElementOfInterest(name)) {
            XMLElement element = this.createXmlElement(name, atts);
            if (LOG.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("START: ").append(name).append(' ').append(element);
                for (int i = 0; i < atts.getLength(); ++i) {
                    buf.append("   ATT: ").append(atts.getLocalName(i)).append(' ').append(atts.getValue(i));
                }
                LOG.debug((Object)buf.toString());
            }
            this.elements[this.nElements++] = element;
            this.handleStartElement(element);
        }
    }

    private XMLElement createXmlElement(String name, Attributes atts) {
        if (this.nFreeElements == 0) {
            return new XMLElement(name, atts);
        }
        XMLElement e = this.freeElements[--this.nFreeElements];
        e.setName(name);
        e.setAttributes(atts);
        e.resetText();
        return e;
    }

    public void endElement(String uri, String localname, String name) throws SAXException {
        if (this.isElementOfInterest(name)) {
            XMLElement e = this.elements[--this.nElements];
            if (LOG.isDebugEnabled()) {
                StringBuffer buf = new StringBuffer();
                buf.append("END: " + e.getName() + " [" + e.getText() + "] " + e + "\n");
                for (int i = 0; i < e.getNumAttributes(); ++i) {
                    buf.append("   ATT: " + e.getAttributeName(i) + " " + e.getAttributeValue(i) + "\n");
                }
                LOG.debug((Object)buf);
            }
            this.handleEndElement(e);
        }
    }

    protected boolean isElementOfInterest(String name) {
        return true;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < this.nElements; ++i) {
            XMLElement e = this.elements[i];
            String test = e.getText();
            if (test.length() > 0) {
                e.addText(RETURNSTRING);
            }
            e.addText(new String(ch, start, length));
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        try {
            URL testIt = new URL(systemId);
            InputSource s = new InputSource(testIt.openStream());
            return s;
        }
        catch (Exception e) {
            LOG.info((Object)("NOTE: Could not open DTD " + systemId + " due to exception"));
            String dtdName = systemId.substring(systemId.lastIndexOf(47) + 1);
            String dtdPath = "/org/argouml/persistence/" + dtdName;
            InputStream is = SAXParserBase.class.getResourceAsStream(dtdPath);
            if (is == null) {
                try {
                    is = new FileInputStream(dtdPath.substring(1));
                }
                catch (Exception ex) {
                    throw new SAXException(e);
                }
            }
            return new InputSource(is);
        }
    }

    public String getJarResource(String cls) {
        String jarFile = "";
        String fileSep = System.getProperty("file.separator");
        String classFile = cls.replace('.', fileSep.charAt(0)) + ".class";
        ClassLoader thisClassLoader = this.getClass().getClassLoader();
        URL url = thisClassLoader.getResource(classFile);
        if (url != null) {
            String urlString = url.getFile();
            int idBegin = urlString.indexOf("file:");
            int idEnd = urlString.indexOf("!");
            if (idBegin > -1 && idEnd > -1 && idEnd > idBegin) {
                jarFile = urlString.substring(idBegin + 5, idEnd);
            }
        }
        return jarFile;
    }

    public void ignoreElement(XMLElement e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NOTE: ignoring tag:" + e.getName()));
        }
    }

    public void notImplemented(XMLElement e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("NOTE: element not implemented: " + e.getName()));
        }
    }
}

