/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.argouml.model.Model;
import org.argouml.sequence2.diagram.FigClassifierRole;
import org.argouml.sequence2.diagram.FigMessage;
import org.argouml.sequence2.diagram.SequenceDiagramGraphModel;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.ModeCreatePolyEdge;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModeCreateMessage
extends ModeCreatePolyEdge {
    private static final Logger LOG = Logger.getLogger(ModeCreateMessage.class);
    private static final int DEFAULT_ACTIVATION_HEIGHT = 50;
    private static final int DEFAULT_MESSAGE_GAP = 20;

    public ModeCreateMessage(Editor par) {
        super(par);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("ModeCreateMessage created with editor:" + this.editor));
        }
    }

    public ModeCreateMessage() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ModeCreateMessage created without editor.");
        }
    }

    public void endAttached(FigEdge fe) {
        super.endAttached(fe);
        SequenceDiagramGraphModel gm = (SequenceDiagramGraphModel)this.getEditor().getGraphModel();
        FigMessage figMessage = (FigMessage)fe;
        Object message = fe.getOwner();
        FigClassifierRole dcr = (FigClassifierRole)fe.getDestFigNode();
        FigClassifierRole scr = (FigClassifierRole)fe.getSourceFigNode();
        this.ensureSpace(figMessage);
        if (figMessage.isSynchCallMessage()) {
            Object returnMessageSource = Model.getFacade().getReceiver(message);
            Object returnMessageDest = Model.getFacade().getSender(message);
            Object returnMessage = gm.connectMessage(returnMessageSource, returnMessageDest, Model.getMessageSort().getReply());
            Model.getCollaborationsHelper().setActivator(returnMessage, message);
            LayerPerspective layer = (LayerPerspective)this.editor.getLayerManager().getActiveLayer();
            FigMessage returnEdge = null;
            List figs = layer.getContents();
            for (Fig fig : figs) {
                if (fig.getOwner() != returnMessage) continue;
                returnEdge = (FigMessage)fig;
                break;
            }
            returnEdge.setSourcePortFig(fe.getDestPortFig());
            returnEdge.setSourceFigNode((FigNode)dcr);
            returnEdge.setDestPortFig(fe.getSourcePortFig());
            returnEdge.setDestFigNode((FigNode)scr);
            Point[] points = returnEdge.getPoints();
            for (int i = 0; i < points.length; ++i) {
                points[i].y = fe.getFirstPoint().y + 50;
            }
            returnEdge.setPoints(points);
            if (returnEdge.isSelfMessage()) {
                returnEdge.convertToArc();
            }
            FigPoly poly = (FigPoly)returnEdge.getFig();
            poly.setComplete(true);
        } else if (figMessage.isReplyMessage()) {
            figMessage.determineActivator();
        }
        FigPoly poly = (FigPoly)fe.getFig();
        poly.setComplete(true);
        dcr.createActivations();
        dcr.renderingChanged();
        if (dcr != scr) {
            scr.createActivations();
            scr.renderingChanged();
        }
    }

    private void ensureSpace(FigMessage figMessage) {
        int firstMessageY;
        int figMessageY;
        FigMessage firstMessageAbove = this.getNearestMessage((FigClassifierRole)this.getSourceFigNode(), figMessage, false);
        if (firstMessageAbove != null && (figMessageY = figMessage.getFirstPoint().y) - (firstMessageY = firstMessageAbove.getFirstPoint().y) < 20) {
            figMessage.translateEdge(0, firstMessageY + 20 - figMessageY);
        }
        LOG.info((Object)"Looking for minimum space below");
        FigMessage firstMessageBelow = this.getNearestMessage((FigClassifierRole)this.getSourceFigNode(), figMessage, true);
        int heightPlusGap = figMessage.isSynchCallMessage() ? 70 : 20;
        if (firstMessageBelow != null && firstMessageBelow.getFirstPoint().y < figMessage.getFirstPoint().y + heightPlusGap) {
            int dy = figMessage.getFirstPoint().y + heightPlusGap - firstMessageBelow.getFirstPoint().y;
            for (FigMessage fig : this.getMessagesBelow(figMessage)) {
                fig.translateEdge(0, dy);
                if (!fig.isCreateMessage()) continue;
                FigClassifierRole fcr = (FigClassifierRole)fig.getDestFigNode();
                fcr.positionHead(fig);
            }
        }
    }

    private List<FigMessage> getMessagesBelow(FigMessage figMessage) {
        ArrayList<FigMessage> messagesBelow = new ArrayList<FigMessage>();
        for (Fig f : this.getEditor().getLayerManager().getContents()) {
            if (!(f instanceof FigMessage) || f == figMessage) continue;
            FigMessage fm = (FigMessage)f;
            if (fm.getFirstPoint().y < figMessage.getFirstPoint().y) continue;
            messagesBelow.add((FigMessage)f);
        }
        return messagesBelow;
    }

    private FigMessage getNearestMessage(FigClassifierRole figClassifierRole, FigMessage figMessage, boolean below) {
        FigMessage nearestMessage = null;
        for (FigEdge fe : figClassifierRole.getFigEdges()) {
            if (!(fe instanceof FigMessage) || fe == figMessage) continue;
            FigMessage fm = (FigMessage)fe;
            int y = fm.getFirstPoint().y;
            if (below) {
                if (!this.isBetween(y, figMessage, nearestMessage)) continue;
                nearestMessage = fm;
                continue;
            }
            if (!this.isBetween(y, nearestMessage, figMessage)) continue;
            nearestMessage = fm;
        }
        return nearestMessage;
    }

    private boolean isBetween(int val, FigMessage message1, FigMessage message2) {
        return !(message1 != null && val < message1.getFirstPoint().y || message2 != null && val > message2.getFirstPoint().y);
    }
}

