/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;
import org.argouml.i18n.Translator;
import org.argouml.model.CollaborationsHelper;
import org.argouml.model.Facade;
import org.argouml.model.Model;
import org.argouml.sequence2.diagram.ActionAddClassifierRole;
import org.argouml.sequence2.diagram.ActionSetAddMessageMode;
import org.argouml.sequence2.diagram.FigClassifierRole;
import org.argouml.sequence2.diagram.FigMessage;
import org.argouml.sequence2.diagram.ModeBroomMessages;
import org.argouml.sequence2.diagram.ModePlaceClassifierRole;
import org.argouml.sequence2.diagram.SequenceDiagramGraphModel;
import org.argouml.sequence2.diagram.SequenceDiagramRenderer;
import org.argouml.uml.diagram.DiagramElement;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.SequenceDiagram;
import org.argouml.uml.diagram.static_structure.ui.FigComment;
import org.argouml.uml.diagram.ui.ActionSetMode;
import org.argouml.uml.diagram.ui.RadioAction;
import org.argouml.uml.diagram.ui.UMLDiagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.LayerPerspectiveMutable;
import org.tigris.gef.base.ModePlace;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

public class UMLSequenceDiagram
extends UMLDiagram
implements SequenceDiagram,
org.argouml.model.SequenceDiagram {
    private Object[] actions;
    private static final Logger LOG = Logger.getLogger(UMLSequenceDiagram.class);

    @Deprecated
    public UMLSequenceDiagram() {
        SequenceDiagramGraphModel gm = new SequenceDiagramGraphModel();
        this.setGraphModel((GraphModel)gm);
        LayerPerspectiveMutable lay = new LayerPerspectiveMutable(this.getName(), (MutableGraphModel)gm);
        this.setLayer((LayerPerspective)lay);
        SequenceDiagramRenderer renderer = new SequenceDiagramRenderer();
        lay.setGraphNodeRenderer((GraphNodeRenderer)renderer);
        lay.setGraphEdgeRenderer((GraphEdgeRenderer)renderer);
        LOG.debug((Object)"Created sequence diagram");
    }

    public UMLSequenceDiagram(Object collaboration) {
        this();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Constructing Sequence Diagram for collaboration " + collaboration));
        }
        try {
            this.setName(this.getNewDiagramName());
        }
        catch (PropertyVetoException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        ((SequenceDiagramGraphModel)this.getGraphModel()).setCollaboration(collaboration);
        this.setNamespace(collaboration);
    }

    public void initialize(Object owner) {
        super.initialize(owner);
        SequenceDiagramGraphModel gm = (SequenceDiagramGraphModel)this.getGraphModel();
        gm.setCollaboration(owner);
    }

    protected Object[] getUmlActions() {
        if (this.actions == null) {
            ArrayList<RadioAction> actionList = new ArrayList<RadioAction>();
            actionList.add(new RadioAction((Action)((Object)new ActionAddClassifierRole())));
            this.getMessageActions(actionList);
            actionList.add(new RadioAction((Action)new ActionSetMode(ModeBroomMessages.class, "button.broom-messages")));
            this.actions = new Object[8];
            boolean i = false;
            this.actions = actionList.toArray();
        }
        return this.actions;
    }

    private List getMessageActions(List actions) {
        actions.add(new RadioAction((Action)((Object)new ActionSetAddMessageMode(Model.getMessageSort().getSynchCall(), "button.new-callaction"))));
        actions.add(new RadioAction((Action)((Object)new ActionSetAddMessageMode(Model.getMessageSort().getASynchSignal(), "button.new-sendaction"))));
        actions.add(new RadioAction((Action)((Object)new ActionSetAddMessageMode(Model.getMessageSort().getReply(), "button.new-returnaction"))));
        actions.add(new RadioAction((Action)((Object)new ActionSetAddMessageMode(Model.getMessageSort().getCreateMessage(), "button.new-createaction"))));
        actions.add(new RadioAction((Action)((Object)new ActionSetAddMessageMode(Model.getMessageSort().getDeleteMessage(), "button.new-destroyaction"))));
        return actions;
    }

    public String getLabelName() {
        return Translator.localize((String)"label.sequence-diagram");
    }

    public void encloserChanged(FigNode enclosed, FigNode oldEncloser, FigNode newEncloser) {
    }

    public boolean isRelocationAllowed(Object base) {
        return Model.getFacade().isACollaboration(base);
    }

    public Collection getRelocationCandidates(Object root) {
        return Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(root, Model.getMetaTypes().getCollaboration());
    }

    public boolean relocate(Object base) {
        ((SequenceDiagramGraphModel)this.getGraphModel()).setCollaboration(base);
        this.setNamespace(base);
        this.damage();
        return true;
    }

    public boolean doesAccept(Object objectToAccept) {
        if (Model.getFacade().isALifeline(objectToAccept)) {
            return true;
        }
        if (Model.getFacade().isAClassifier(objectToAccept)) {
            return true;
        }
        return Model.getFacade().isAComment(objectToAccept);
    }

    private Object makeNewCR(Object base) {
        Object node = null;
        Editor ce = Globals.curEditor();
        GraphModel gm = ce.getGraphModel();
        if (gm instanceof SequenceDiagramGraphModel) {
            Object collaboration = ((SequenceDiagramGraphModel)gm).getCollaboration();
            node = Model.getCollaborationsFactory().buildClassifierRole(collaboration);
        }
        Model.getCollaborationsHelper().addBase(node, base);
        return node;
    }

    private FigClassifierRole makeNewFigCR(Object classifierRole, Point location) {
        if (classifierRole != null) {
            Rectangle bounds = new Rectangle();
            for (Fig fig : this.getLayer().getContentsNoEdges()) {
                if (!(fig instanceof FigClassifierRole)) continue;
                bounds.y = fig.getY();
                bounds.height = fig.getHeight();
                break;
            }
            if (location != null) {
                if (bounds.y == 0) {
                    bounds.y = location.y;
                }
                bounds.x = location.x;
            }
            FigClassifierRole newCR = new FigClassifierRole(classifierRole, bounds, this.getDiagramSettings());
            this.getGraphModel().getNodes().add(newCR.getOwner());
            return newCR;
        }
        return null;
    }

    public DiagramElement createDiagramElement(Object modelElement, Rectangle bounds) {
        Object figNode = null;
        DiagramSettings settings = this.getDiagramSettings();
        if (Model.getFacade().isAComment(modelElement)) {
            figNode = new FigComment(modelElement, bounds, settings);
        } else if (Model.getFacade().isAClassifierRole(modelElement)) {
            if (!this.getGraphModel().getNodes().contains(modelElement)) {
                figNode = this.makeNewFigCR(modelElement, null);
            }
        } else if (Model.getFacade().isAClassifier(modelElement)) {
            figNode = this.makeNewFigCR(this.makeNewCR(modelElement), bounds.getLocation());
        }
        if (figNode != null) {
            LOG.debug((Object)("Model element " + modelElement + " converted to " + figNode));
        } else {
            LOG.debug((Object)("Dropped object NOT added " + figNode));
        }
        return figNode;
    }

    public String getInstructions(Object droppedObject) {
        if (Model.getFacade().isAClassifierRole(droppedObject)) {
            return super.getInstructions(droppedObject);
        }
        if (Model.getFacade().isAClassifier(droppedObject)) {
            return Translator.localize((String)"misc.message.click-on-diagram-to-add-as-cr", (Object[])new Object[]{Model.getFacade().toString(droppedObject)});
        }
        return super.getInstructions(droppedObject);
    }

    public ModePlace getModePlace(GraphFactory gf, String instructions) {
        return new ModePlaceClassifierRole(gf, instructions);
    }

    public Object getCollaboration() {
        return ((SequenceDiagramGraphModel)this.getGraphModel()).getCollaboration();
    }

    public void postLoad() {
        super.postLoad();
        Facade facade = Model.getFacade();
        LOG.info((Object)("doing postLoad on " + this.getName()));
        Object collaboration = this.getCollaboration();
        Object correctInteraction = null;
        for (Fig f : this.getLayer().getContents()) {
            Object interaction;
            Object context;
            Object modelElement = f.getOwner();
            if (!(f instanceof FigMessage) || (context = facade.getContext(interaction = facade.getInteraction(modelElement))) != collaboration) continue;
            correctInteraction = interaction;
        }
        if (correctInteraction != null) {
            CollaborationsHelper collabHelper = Model.getCollaborationsHelper();
            for (Fig f : this.getLayer().getContents()) {
                Object cr;
                Object namespace;
                if (f instanceof FigMessage) {
                    Object message = f.getOwner();
                    LOG.info((Object)("Checking message " + f.getOwner()));
                    Object interaction = facade.getInteraction(message);
                    Object context = facade.getContext(interaction);
                    Object action = facade.getAction(message);
                    if (context == collaboration) continue;
                    LOG.warn((Object)("namespace of interaction does not match collaboration - moving " + message + " to " + correctInteraction));
                    collabHelper.addMessage(correctInteraction, message);
                    Model.getCoreHelper().setNamespace(action, collaboration);
                    continue;
                }
                if (!(f instanceof FigClassifierRole) || (namespace = facade.getNamespace(cr = f.getOwner())) == collaboration) continue;
                LOG.warn((Object)("namespace of classifierrole does not match collaboration - moving " + cr + " to " + collaboration));
                Model.getCoreHelper().setNamespace(cr, collaboration);
                Collection associationEndRoles = facade.getAssociationEnds(cr);
                for (Object assEndRole : associationEndRoles) {
                    Object assRole = facade.getAssociation(assEndRole);
                    if (facade.getNamespace(assRole) == collaboration) continue;
                    Model.getCoreHelper().setNamespace(assRole, collaboration);
                }
            }
        }
    }
}

