/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.check.types;

import java.util.HashSet;
import tudresden.ocl.check.OclTypeException;
import tudresden.ocl.check.types.Basic;
import tudresden.ocl.check.types.Collection;
import tudresden.ocl.check.types.ModelFacade;
import tudresden.ocl.check.types.OclType;
import tudresden.ocl.check.types.Type;
import tudresden.ocl.check.types.TypeFactory;
import tudresden.ocl.parser.node.Node;

public class DefaultTypeFactory
implements TypeFactory {
    static HashSet predefinedTypeNames = new HashSet();
    protected ModelFacade myModelFacade;

    public DefaultTypeFactory(ModelFacade mf) {
        this.myModelFacade = mf;
    }

    public Type getBoolean() {
        return Basic.BOOLEAN;
    }

    public Type getInteger() {
        return Basic.INTEGER;
    }

    public Type getReal() {
        return Basic.REAL;
    }

    public Type getString() {
        return Basic.STRING;
    }

    public Type getSet() {
        return this.getSet(null);
    }

    public Type getSet(Type param) {
        return new Collection(47, param);
    }

    public Type getBag() {
        return this.getBag(null);
    }

    public Type getBag(Type param) {
        return new Collection(97, param);
    }

    public Type getSequence() {
        return this.getSequence(null);
    }

    public Type getSequence(Type param) {
        return new Collection(690, param);
    }

    public Type getCollection() {
        return this.getCollection(null);
    }

    public Type getCollection(Type param) {
        return new Collection(23, param);
    }

    public Type getEnumerationElement() {
        return Basic.ENUMERATION;
    }

    public Type getOclType(Type t) {
        return new OclType(t);
    }

    public Type getOclAny() {
        return Basic.OCLANY;
    }

    public Type get(String name) {
        if (predefinedTypeNames.contains(name)) {
            if (name.equals("Boolean")) {
                return this.getBoolean();
            }
            if (name.equals("Integer")) {
                return this.getInteger();
            }
            if (name.equals("Real")) {
                return this.getReal();
            }
            if (name.equals("String")) {
                return this.getString();
            }
            if (name.equals("Collection")) {
                return this.getCollection();
            }
            if (name.equals("Set")) {
                return this.getSet();
            }
            if (name.equals("Bag")) {
                return this.getBag();
            }
            if (name.equals("Sequence")) {
                return this.getSequence();
            }
            if (name.equals("Enumeration")) {
                return this.getEnumerationElement();
            }
            if (name.equals("OclAny")) {
                return this.getOclAny();
            }
            return null;
        }
        if (name.startsWith("Collection")) {
            return this.getCollection(this.get(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)).trim()));
        }
        if (name.startsWith("Sequence")) {
            return this.getSequence(this.get(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)).trim()));
        }
        if (name.startsWith("Set")) {
            return this.getSet(this.get(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)).trim()));
        }
        if (name.startsWith("Bag")) {
            return this.getBag(this.get(name.substring(name.indexOf(40) + 1, name.lastIndexOf(41)).trim()));
        }
        return this.myModelFacade.getClassifier(name);
    }

    public boolean conforms(Type found, Type expected) {
        return found.conformsTo(expected);
    }

    public void assertTrue(Type found, Type expected, Node where) {
        if (!this.conforms(found, expected)) {
            throw new OclTypeException("type error in \"" + where + "\" :expected " + expected + ", found " + found);
        }
    }

    public static String toString(Type[] array) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            if (i != 0) {
                sbuf.append(",");
            }
            sbuf.append(array[i]);
            ++i;
        }
        return sbuf.toString();
    }

    static {
        predefinedTypeNames.add("Integer");
        predefinedTypeNames.add("Real");
        predefinedTypeNames.add("Boolean");
        predefinedTypeNames.add("String");
        predefinedTypeNames.add("Bag");
        predefinedTypeNames.add("Set");
        predefinedTypeNames.add("Sequence");
        predefinedTypeNames.add("Collection");
        predefinedTypeNames.add("Enumeration");
        predefinedTypeNames.add("OclAny");
    }
}

