/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import tudresden.ocl.lib.FeatureListener;
import tudresden.ocl.lib.Ocl;
import tudresden.ocl.lib.OclAny;
import tudresden.ocl.lib.OclBoolean;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclSequence;
import tudresden.ocl.lib.OclType;

public class OclAnyImpl
extends OclAny {
    private Object applicationObject;
    private static FeatureListener featurelistener = null;
    static /* synthetic */ Class class$java$lang$Object;

    public OclAnyImpl(Object o) {
        this.applicationObject = o;
    }

    public OclAnyImpl(int dummy, String reason) {
        super(dummy, reason);
    }

    public OclBoolean isEqualTo(Object o) {
        if (!(o instanceof OclAnyImpl)) {
            System.out.println("OclAnyImpl isEqualTo() is called with a non-OclAnyImpl parameter");
            return OclBoolean.FALSE;
        }
        OclAnyImpl other = (OclAnyImpl)o;
        if (this.isUndefined()) {
            return new OclBoolean(0, this.getUndefinedReason());
        }
        if (other.isUndefined()) {
            return new OclBoolean(0, other.getUndefinedReason());
        }
        if (this.applicationObject == other.applicationObject) {
            return OclBoolean.TRUE;
        }
        return OclBoolean.FALSE;
    }

    public OclBoolean isNotEqualTo(Object o) {
        return this.isEqualTo(o).not();
    }

    public OclRoot getFeature(String attributeName) {
        return this.getFeatureQualified(attributeName, null);
    }

    public OclRoot getFeatureQualified(String attributeName, Object qualifier) {
        if (this.isUndefined()) {
            return this;
        }
        if (this.applicationObject == null) {
            return new OclAnyImpl(0, "feature " + attributeName + " of null-object requested");
        }
        try {
            AccessibleObject f = null;
            String[] possibleNames = Ocl.getNames(attributeName);
            int i = 0;
            while (f == null && i < possibleNames.length) {
                Class<?> searchClass = this.applicationObject.getClass();
                while (searchClass != null && f == null) {
                    try {
                        f = searchClass.getDeclaredField(possibleNames[i]);
                    }
                    catch (NoSuchFieldException nsfe) {
                        f = null;
                        searchClass = searchClass.getSuperclass();
                    }
                }
                ++i;
            }
            if (f == null) {
                String message = "non-existent field " + attributeName + " of object \"" + this.applicationObject + "\" (" + this.applicationObject.getClass() + ") queried";
                if (!Ocl.TOLERATE_NONEXISTENT_FIELDS) {
                    throw new OclException(message);
                }
                return new OclAnyImpl(0, message);
            }
            if (featurelistener != null) {
                featurelistener.onField((Field)f, this.applicationObject);
            }
            f.setAccessible(true);
            Object feature = ((Field)f).get(this.applicationObject);
            if (qualifier != null) {
                if (feature instanceof Map) {
                    if ((feature = ((Map)feature).get(qualifier)) == null) {
                        return new OclAnyImpl(0, "field " + attributeName + " of object \"" + this.applicationObject + "\" (" + this.applicationObject.getClass() + ") contains no object qualified by \"" + qualifier + '\"');
                    }
                } else {
                    throw new OclException("object " + feature + " cannot be qualified by " + qualifier);
                }
            }
            if (feature != null) {
                return Ocl.getOclRepresentationFor(feature);
            }
            OclRoot oclrep = Ocl.getOclRepresentationForNull(((Field)f).getType());
            if (oclrep != null) {
                return oclrep;
            }
            return new OclAnyImpl(0, "field " + attributeName + " of object \"" + this.applicationObject + "\" (" + this.applicationObject.getClass() + ") is null");
        }
        catch (IllegalAccessException iae) {
            return new OclAnyImpl(0, "tried to query non-public field " + attributeName + " of object " + this.applicationObject);
        }
    }

    public static Method findMethod(Class myclass, String name, Class[] params) {
        HashSet<Class> hsVisited = new HashSet<Class>();
        LinkedList llToVisit = new LinkedList();
        if (myclass.isInterface()) {
            llToVisit.add(class$java$lang$Object == null ? (class$java$lang$Object = OclAnyImpl.class$("java.lang.Object")) : class$java$lang$Object);
        }
        Class iclass = myclass;
        while (iclass != null) {
            Method[] methods = iclass.getDeclaredMethods();
            Method foundmethod = null;
            int i = 0;
            while (i < methods.length) {
                Class<?>[] methodparams;
                if (name.equals(methods[i].getName()) && params.length == (methodparams = methods[i].getParameterTypes()).length) {
                    int j = 0;
                    while (j < methodparams.length) {
                        if (!methodparams[j].isAssignableFrom(params[j])) {
                            // empty if block
                        }
                        ++j;
                    }
                    if (foundmethod == null) {
                        foundmethod = methods[i];
                    } else {
                        throw new OclException("ambigious method " + name + " of " + myclass + ") queried.");
                    }
                }
                ++i;
            }
            if (foundmethod != null) {
                return foundmethod;
            }
            if (iclass.isInterface()) {
                Class<?>[] ca = iclass.getInterfaces();
                int i2 = 0;
                while (i2 < ca.length) {
                    if (!hsVisited.contains(ca[i2])) {
                        llToVisit.add(ca[i2]);
                    }
                    ++i2;
                }
            } else if (!hsVisited.contains(iclass.getSuperclass())) {
                llToVisit.add(iclass.getSuperclass());
            }
            hsVisited.add(iclass);
            iclass = !llToVisit.isEmpty() ? (Class)llToVisit.remove(0) : null;
        }
        return null;
    }

    public OclRoot getFeature(String methodName, Object[] params) {
        if (this.isUndefined()) {
            return this;
        }
        if (this.applicationObject == null) {
            return new OclAnyImpl(0, "OclAnyImpl.getFeature for null-Object called");
        }
        try {
            if (params == null) {
                params = new Object[]{};
            }
            Class[] paramTypes = new Class[params.length];
            int i = 0;
            while (i < params.length) {
                paramTypes[i] = params[i].getClass();
                ++i;
            }
            Method foundmethod = OclAnyImpl.findMethod(this.applicationObject.getClass(), methodName, paramTypes);
            if (foundmethod == null) {
                String message = "non-existent method " + methodName + " of object \"" + this.applicationObject + "\" (" + this.applicationObject.getClass() + ") queried";
                if (!Ocl.TOLERATE_NONEXISTENT_FIELDS) {
                    throw new OclException(message);
                }
                return new OclAnyImpl(0, message);
            }
            if (featurelistener != null) {
                featurelistener.onMethod(foundmethod, this.applicationObject);
            }
            ((AccessibleObject)foundmethod).setAccessible(true);
            Object feature = foundmethod.invoke(this.applicationObject, params);
            return Ocl.getOclRepresentationFor(feature);
        }
        catch (IllegalArgumentException iae) {
            return new OclAnyImpl(0, "tried to invoke method " + methodName + " of object " + this.applicationObject + "with illegal parameters");
        }
        catch (InvocationTargetException ite) {
            return new OclAnyImpl(0, "an exception occured as result of the invokation of the method " + methodName + " of object " + this.applicationObject);
        }
        catch (IllegalAccessException iae) {
            return new OclAnyImpl(0, "tried to invoke non-public method " + methodName + " of object " + this.applicationObject);
        }
    }

    public OclSequence getFeatureAsSequence(String name) {
        if (this.isUndefined()) {
            return new OclSequence(0, this.getUndefinedReason());
        }
        if (this.applicationObject == null) {
            return new OclSequence(0, "OclAnyImpl.getFeatureAsSequence for null-Object called");
        }
        try {
            Object feature;
            Field f = null;
            String[] possibleNames = Ocl.getNames(name);
            int i = 0;
            while (f == null && i < possibleNames.length) {
                try {
                    f = this.applicationObject.getClass().getField(possibleNames[i]);
                }
                catch (NoSuchFieldException nsfe) {
                    f = null;
                }
                ++i;
            }
            if (f == null) {
                return new OclSequence(0, "non-existent field " + name + " of object " + this.applicationObject + " queried");
            }
            if (featurelistener != null) {
                featurelistener.onField(f, this.applicationObject);
            }
            if ((feature = f.get(this.applicationObject)) == null) {
                return new OclSequence(0, "non-existent field " + name + " of object " + this.applicationObject + " is null");
            }
            return Ocl.getOclSequenceFor(feature);
        }
        catch (IllegalAccessException iae) {
            return new OclSequence(0, "tried to query non-public field " + name + " of object " + this.applicationObject);
        }
    }

    public boolean equals(Object o) {
        try {
            return this.isEqualTo(o).isTrue();
        }
        catch (OclException e) {
            return false;
        }
    }

    public int hashCode() {
        if (this.applicationObject == null) {
            return 0;
        }
        return this.applicationObject.hashCode();
    }

    public String toString() {
        String s = this.applicationObject == null ? "" : this.applicationObject.toString();
        return "OclAnyImpl<" + s + ">";
    }

    public OclType oclType() {
        if (this.isUndefined()) {
            return new OclType(0, this.getUndefinedReason());
        }
        return new OclType(this.applicationObject.getClass());
    }

    public Object getObject() {
        return this.applicationObject;
    }

    public static void setFeatureListener(FeatureListener f) {
        if (f == null) {
            throw new RuntimeException();
        }
        if (featurelistener != null) {
            throw new RuntimeException();
        }
        featurelistener = f;
    }

    public static void clearFeatureListener() {
        if (featurelistener == null) {
            throw new RuntimeException();
        }
        featurelistener = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

