/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.lib;

import tudresden.ocl.lib.OclAny;
import tudresden.ocl.lib.OclAnyImpl;
import tudresden.ocl.lib.OclException;
import tudresden.ocl.lib.OclRoot;
import tudresden.ocl.lib.OclType;

public class OclBoolean
extends OclAny {
    public static final OclBoolean FALSE = new OclBoolean(false);
    public static final OclBoolean TRUE = new OclBoolean(true);
    private boolean bValue;

    public OclBoolean(int dummy, String undefinedreason) {
        super(dummy, undefinedreason);
    }

    private OclBoolean(boolean b) {
        this.bValue = b;
    }

    public OclBoolean isEqualTo(Object o) {
        if (!(o instanceof OclBoolean)) {
            System.out.println("OclBoolean isEqualTo() is called with a non-OclBoolean parameter");
            return FALSE;
        }
        OclBoolean other = (OclBoolean)o;
        if (this.isUndefined()) {
            return this;
        }
        if (other.isUndefined()) {
            return other;
        }
        if (this == o) {
            return TRUE;
        }
        return FALSE;
    }

    public OclBoolean isNotEqualTo(Object o) {
        return this.isEqualTo(o).not();
    }

    public OclBoolean xor(OclBoolean b) {
        return this.isNotEqualTo(b);
    }

    public OclBoolean or(OclBoolean b) {
        if (this == TRUE) {
            return TRUE;
        }
        if (b == TRUE) {
            return TRUE;
        }
        if (this.isUndefined()) {
            return this;
        }
        if (b.isUndefined()) {
            return b;
        }
        return FALSE;
    }

    public OclBoolean and(OclBoolean b) {
        if (this == FALSE || b == FALSE) {
            return FALSE;
        }
        if (this.isUndefined()) {
            return this;
        }
        if (b.isUndefined()) {
            return b;
        }
        return TRUE;
    }

    public OclBoolean not() {
        if (this == TRUE) {
            return FALSE;
        }
        if (this == FALSE) {
            return TRUE;
        }
        if (this.isUndefined()) {
            return this;
        }
        throw new RuntimeException();
    }

    public OclBoolean implies(OclBoolean b) {
        return this.not().or(this.and(b));
    }

    public OclRoot ifThenElse(OclRoot param1, OclRoot param2) {
        if (this.isUndefined()) {
            return new OclAnyImpl(0, this.getUndefinedReason());
        }
        if (this.isTrue()) {
            return param1;
        }
        return param2;
    }

    public boolean isTrue() {
        if (this.isUndefined()) {
            throw new OclException("tried to evaluate undefined OclBoolean value: " + this.getUndefinedReason());
        }
        return this.bValue;
    }

    public OclRoot getFeature(String name) {
        return new OclBoolean(0, "feature " + name + " of OclBoolean requested");
    }

    public OclType oclType() {
        if (this.isUndefined()) {
            return new OclType(0, this.getUndefinedReason());
        }
        return OclType.typeBoolean;
    }

    public String toString() {
        if (this.isUndefined()) {
            return "OclBoolean<UNDEFINED:" + this.getUndefinedReason() + ">";
        }
        return "OclBoolean<" + (this.bValue ? "TRUE>" : "FALSE>");
    }
}

