/*
 * Decompiled with CFR 0.152.
 */
package tudresden.ocl.parser;

import java.util.StringTokenizer;

public class OclParserException
extends RuntimeException {
    private String m_sDetailMessage;
    private int m_nErrorLine;
    private int m_nErrorCol;

    public OclParserException(String s) {
        this.extractErrorPosition(s);
    }

    public String getMessage() {
        return this.m_sDetailMessage;
    }

    public int getErrorLine() {
        return this.m_nErrorLine;
    }

    public int getErrorCol() {
        return this.m_nErrorCol;
    }

    private void extractErrorPosition(String sDetailMessage) {
        if (sDetailMessage.charAt(0) == '[') {
            StringTokenizer st = new StringTokenizer(sDetailMessage.substring(1), ",]");
            try {
                this.m_nErrorLine = Integer.parseInt(st.nextToken());
                this.m_nErrorCol = Integer.parseInt(st.nextToken());
                this.m_sDetailMessage = st.nextToken("").substring(2);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
                this.m_sDetailMessage = sDetailMessage;
                this.m_nErrorLine = -1;
                this.m_nErrorCol = -1;
            }
        } else {
            this.m_sDetailMessage = sDetailMessage;
            this.m_nErrorLine = -1;
            this.m_nErrorCol = -1;
        }
    }
}

