#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.automount.sh.in,v 1.6 2006/12/21 12:49:11 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:

# This contains all of the functions specific to the automount sub-system.

amhash() {
	basedir="${1}"
	key="${2}"
	# build correct string
	evalkey="`eval echo "${AUTOMOUNT_HASHING}"`"
	echo "${basedir}/${evalkey}"
}

amaddraw() {
	mapbasedn="$1"
	key="$2"
	opt="$3"
	src="$4"
	desc="$5"

	append "dn: cn=${key},${mapbasedn}"
	append "changetype: add"
	append "objectClass: automount"
	append "cn: ${key}"
	append "automountInformation: ${opt} ${src}"
	[ -n "${desc}" ] && append "description: ${desc}";
	append "\n\n"
	runmodify
}

amadd() {
	[ -z "${modulename}" ] && modulename="amadd"

	am_description=""
	am_options=""	
	unset OPTION OPTARG OPTIND
	while getopts "d:o:O" OPTION; do
		case "${OPTION}" in
		d) am_description="${OPTARG}" ;;
		o) am_options="${OPTARG}" ;;
		O) am_options="${AUTOMOUNT_OPTIONS_DEFAULT}" ;;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 3 ]; then
		print_usage ${modulename}
		exit 2
	else
		map="$1"
		key="$2"
		src="$3"
	fi
	mapbasedn="ou=${map},${AUTOMOUNT_BASEDN}"

	search_attr "${AUTOMOUNT_BASEDN}" "(&(ou=${map})(|(objectclass=automountMap)(objectclass=organizationalUnit)))" "ou: ${map}" 
	if [ $? -ne 0 ]; then
		echo "${modulename}: Automount map \"${map}\" does not exist" 1>&2
		exit 9
	fi

	amaddraw "${mapbasedn}" "${key}" "${am_options}" "${src}" "${am_description}"
}

amdel() {
	[ -z "${modulename}" ] && modulename="amdel"

	if [ "${#}" -ne 2 ]; then
		print_usage ${modulename}
		exit 2
	else
		map="$1"
		key="$2"
	fi
	mapbasedn="ou=${map},${AUTOMOUNT_BASEDN}"
	append_dn_delete "cn=${key},${mapbasedn}"
	runmodify
}

ammapadd() {
	[ -z "${modulename}" ] && modulename="ammapadd"

	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		map="$1"
	fi
	mapbasedn="ou=${map},${AUTOMOUNT_BASEDN}"
	
	search_attr "${AUTOMOUNT_BASEDN}" "(&(ou=${map})(|(objectclass=automountMap)(objectclass=organizationalUnit)))" "ou: ${map}" 2>/dev/null
	if [ $? -eq 0 ]; then
		echo "${modulename}: Automount map \"${map}\" exists"
		exit 9
	fi
	
	append "dn: ${mapbasedn}"
	append "changetype: add"
	append "objectClass: automountMap"
	append "ou: ${map}"
	append "\n\n"
	runmodify
}

ammapdel() {
	[ -z "${modulename}" ] && modulename="amdel"

	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		map="$1"
		key="$2"
	fi
	mapbasedn="ou=${map},${AUTOMOUNT_BASEDN}"
	append_dn_delete "${mapbasedn}"
	runmodify
}
