#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.common.sh.in,v 1.17 2007/03/30 09:04:50 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:
# This contains all of the common functions.

grabinteractiveinput() {
	msg="${1}"
	setting="${2}"
	echo -en "${msg}"
	read userinput
	userinput="`echo "${userinput}" | ${SEDEXT} -e 's/^[[:space:]]*//g;s/[[:space:]]*$//g;'`"
	eval ${setting}="${userinput}"
}

# Call me nuts, I just wrote set functions in shell!
# -Robin
set_union() {
	a="$1"
	b="$2"
	t="$a"
	for i in $b; do
		echo "${a}" | ${GREP} -wqs "${i}"
		# if not there, add
		[ "$?" -ne 0 ] && t="${t} ${i}"
	done
	echo "$t"
}

set_intersection() {
	a="$1"
	b="$2"
	t=''
	if [ -z "$a" -o -z "$b" ]; then
		t=''
	else
		for i in $a; do
			echo "${b}" | ${GREP} -wqs "${i}"
			# if there, add
			[ "$?" -eq 0 ] && t="${t} ${i}"
		done
	fi
	echo "$t"
}

set_complement() {
	a="$1"
	b="$2"
	t=''
	# check for special cases
	if [ -z "$a" ]; then
		t="$b"
	elif [ -z "$b" ]; then
		t=''
	# base case
	else
		for i in $a; do
			echo "${b}" | ${GREP} -wqs "${i}"
			# if not there, add
			[ "$?" -ne 0 ] && t="${t} ${i}"
		done
	fi
	echo "$t"
}

set_unique() {
	a="$1"
	t=""
	for i in $a ; do
		echo "${t}" | ${GREP} -wqs "${i}"
		# if not there, add
		[ "$?" -ne 0 ] && t="${t} ${i}"
	done
	echo "$t"
}

# eg: 
# ldap_search_getattr "${GROUP_BASEDN}" "gidNumber=100" cn
# (returns 'username' on systems with that initial data in LDAP)
ldap_search_getattr() {
	basedn="${1}"
	search="${2}"
	attr="${3}"
	regex="^${attr}: "
	regex_base64="^${attr}:: "
	# TODO: turn this off again before 
	[[ -n "$DEBUG" ]] && echo "ldap_search_getattr: basedn=${basedn} search=${search} attr=${attr}"  1>&2
	output="$(${LDAPSEARCH_CMD} -b "${basedn}" "${search}" ${attr})"
	if [ "${output}" != "${output#${regex_base64}}" ]; then
		echo "${output}" | ${SEDEXT} -n -e "/${regex}/{s~${regex_base64}~~ ; p}" | ldap_base64_decode_pipe
	else
		echo "${output}" | ${SEDEXT} -n -e "/${regex}/{s~${regex}~~ ; p}"
	fi
}

ldap_base64_decode() {
	echo "$*" | ldap_base64_decode_pipe
}
ldap_base64_encode() {
	echo "$*" | ldap_base64_encode_pipe
}
ldap_base64_decode_pipe() {
	${PERL} -MMIME::Base64 -e '$p = ""; while(<STDIN>) { chomp ; $p .= $_; } print(decode_base64($p));'
}
ldap_base64_encode_pipe() {
	${PERL} -MMIME::Base64 -e '$p = ""; while(<STDIN>) { chomp ; $p .= $_; } print(encode_base64($p));'
}

search_attr() {
	[ -n "$DEBUG" ] && echo ${LDAPSEARCH_CMD} -b "${1}" "${2}" 1>&2
	${LDAPSEARCH_CMD} -b "${1}" "${2}" | ${GREP} -qs "^${3}$"
	return "$?"
}

search_smbhost() {
	search_attr "${SAMBAHOST_BASEDN}" "${1}=${2}" "${1}: ${2}"
	return "$?"
}

search_host() {
	search_attr "${HOST_BASEDN}" "${1}=${2}" "${1}: ${2}"
	return "$?"
}
search_user() {
	search_attr "${USER_BASEDN}" "${1}=${2}" "${1}: ${2}"
	return "$?"
}

search_group() {
	search_attr "${GROUP_BASEDN}" "${1}=${2}" "${1}: ${2}"
	return "$?"
}
getent_group_columnmapping() {
	case "$1" in
		cn) echo 1;;
		password) echo 2;;
		gidNumber) echo 3;;
		uid) echo 4;;
	esac
}
getent_group_getattr() {
	matchcolumn="$(getent_group_columnmapping ${1%=*})"
	matchstring="${1#*=}"
	fetchcolumn="$(getent_group_columnmapping ${2})"
	awkexp="{if(\$${matchcolumn} == \"$matchstring\") print \$${fetchcolumn}}" 
	${GETENT} group "${matchstring}" | ${AWK} -F: "${awkexp}"
}
search_group_files() {
	getent_group_getattr "${1}=${2}" "${1}" | ${GREP} -qs "^${2}$"
	return "$?"
}

append() {
	[ "x${*}" != "x" ] && COMMAND="${COMMAND}\n${*}"
}

append_attrib_replace() {
	local attrib="$1"
	shift
	append "replace: ${attrib}"
	append "${attrib}: ${*}"
	append "-"
}
append_attrib_replace_base64() {
	local attrib="$1"
	shift
	local value="$(ldap_base64_encode "${*}")"
	append "replace: ${attrib}"
	append "${attrib}:: ${value}"
	append "-"
}
append_attrib_add() {
	local attrib="$1"
	shift
	append "add: ${attrib}"
	append "${attrib}: ${*}"
	append "-"
}
append_attrib_add_base64() {
	local attrib="$1"
	shift
	local value="$(ldap_base64_encode "${*}")"
	append "add: ${attrib}"
	append "${attrib}: ${value}"
	append "-"
}
append_attrib_delete() {
	local attrib="$1"
	shift
	append "delete: ${attrib}"
	if [ -n "$*" ]; then
		append "${attrib}: ${*}"
	fi
	append "-"
}
append_dn_delete() {
	local dn="$1"
	shift
	append "dn: ${dn}"
	append "changetype: delete"
	# need two blank lines
	append "\n"
}

runmodify() {
if [ -n "${DEBUG}" ]; then
	echo LDAP Modify:
	echo -------
	[ -n "${COMMAND}" ] && echo -e "${COMMAND}" | ${UNIQ}
	echo -------
fi

[ -n "${COMMAND}" ] && echo -e "${COMMAND}" | ${LDAPMODIFY_CMD} > /dev/null
unset COMMAND
}

runadd() {
if [ -n "${DEBUG}" ]; then
	echo LDAP Add:
	echo -------
	[ -n "${COMMAND}" ] && echo -e "${COMMAND}" | ${UNIQ}
	echo -------
fi
[ -n "${COMMAND}" ] && echo -e "${COMMAND}" | ${LDAPADD_CMD} > /dev/null
unset COMMAND
}

rundelete() {
if [ -n "${DEBUG}" ]; then
	echo LDAP Delete
	echo -------
	echo "${*}"
	echo -------
fi
[ -n "${*}" ] && ${LDAPDELETE_CMD} "${*}" > /dev/null
unset COMMAND
}

# Convert N days since Jan 1, 1970 to a date
# first paramater is the days
# rest is passed to date
days_to_date() {
	local D="${1}"
	shift
	#${DATE} -u -d "Jan $((${D}+1)), 1970" ${OPT}
	${DATE} -u -d "00:00:00 1970-01-01 UTC +$D days" "${*}"
}

# Does the reverse of days_to_date
# expects a date
# returns a number of days since Jan 1, 1970
date_to_days() {
	local UNIXTIMESTAMP="$(${DATE} -u +%s -d "${*}")"
	echo $((${UNIXTIMESTAMP}/(3600*24)))
}

daysnow() {
	date_to_days `${DATE} -R -u`
}

isinteger() {
	echo "${1}" | ${GREP} -qs '[[:digit:]]'
}

# Find a free UID to use
usernextfreeuid() {
	uidlist="$(ldap_search_getattr "${USER_BASEDN}" "(uidNumber=*)" "uidNumber" | ${SORT} -rg)"
	# if nothing was returned, the next number up is ours
	# --> we'll return empty.
	# we do NOT do UID recycling at all, our code used to, but it turns out to be really slow
	for i in ${uidlist} ; do
		if [ ${i} -lt ${UIDNUMBERMAX} -a ${i} -ge ${UIDNUMBERMIN} ]; then
			i=$((${i}+1))
			if [ ${i} -lt ${UIDNUMBERMAX} -a ${i} -gt ${UIDNUMBERMIN} ]; then
				echo $i
				return 0
			fi
		fi
	done
	return 1
}
