#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.host.sh.in,v 1.6 2006/12/21 02:28:17 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:
# This contains all of the functions specific to the host sub-system.

hostadd() {
	[ -z "${modulename}" ] && modulename="hostadd"

	unset OPTION OPTARG OPTIND
	while getopts "e:i:a:" OPTION; do
		case "${OPTION}" in
			e) ETHERS="${OPTARG//,/ } ${ETHERS}";;
			i) IPS="${OPTARG//,/ } ${IPS}";;
			a) ALIASES="${OPTARG//,/ } ${ALIASES}";;
			*) print_usage ${modulename} ; exit 1;;
		esac
	done

	ETHERS="$(set_unique "${ETHERS}")"
	IPS="$(set_unique "${IPS}")"
	ALIASES="$(set_unique "${ALIASES}")"

	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		NAME="${1}"
	fi

	search_host "cn" "${NAME}"

	if [ "$?" -eq 0 ]; then
		echo "${modulename}: User \"${NAME}\" exists"
		exit 9
	fi

	# Setup the commands
	append "dn: cn=${NAME},${HOST_BASEDN}"
	append "changetype: add"
	append "objectClass: top"
	append "objectClass: device"
	append "cn: ${NAME}"

	if [ -n "${ETHERS}" ]; then
		append "objectClass: ieee802device"
		for i in ${ETHERS}; do
			append "macAddress: ${i}"
		done
	fi
	if [ -n "${IPS}" ]; then
		append "objectClass: ipHost"
		for i in ${IPS}; do
			append "ipHostNumber: ${i}"
		done
	fi
	if [ -n "${ALIASES}" ]; then
		for i in ${ALIASES}; do
			append "cn: ${i}"
		done
	fi

	append "\n\n"

	runmodify
}

hostdel() {
	[ -z "${modulename}" ] && modulename="hostdel"
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		NAME="${1}"
	fi
	search_host "cn" "${NAME}"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: Host \"${NAME}\" does not exist"
		exit 6
	fi
	append_dn_delete "cn=${NAME},${HOST_BASEDN}"
	runmodify
}

hostmod() {
	[ -z "${modulename}" ] && modulename="hostmod"
	if [ "${#}" -le 1 ]; then
		print_usage ${modulename}
		echo "${modulename}: No flags given"
		exit 2
	fi
	unset OPTION OPTARG OPTIND
	while getopts "e:E:i:I:a:A:n:" OPTION; do
		case "${OPTION}" in
			e) ETHERS_ADD="${OPTARG//,/ } ${ETHERS_ADD}";;
			E) ETHERS_DELETE="${OPTARG//,/ } ${ETHERS_DELETE}";;
			i) IPS_ADD="${OPTARG//,/ } ${IPS_ADD}";;
			I) IPS_DELETE="${OPTARG//,/ } ${IPS_DELETE}";;
			a) ALIASES_ADD="${OPTARG//,/ } ${ALIASES_ADD}";;
			A) ALIASES_DELETE="${OPTARG//,/ } ${ALIASES_DELETE}";;
			n) NEWNAME="${OPTARG}";;
			*) print_usage ${modulename} ; exit 1;;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		NAME="${1}"
	fi

	ETHERS_ADD="$(set_unique "${ETHERS_ADD}")"
	IPS_ADD="$(set_unique "${IPS_ADD}")"
	ALIASES_ADD="$(set_unique "${ALIASES_ADD}")"
	ETHERS_DELETE="$(set_unique "${ETHERS_DELETE}")"
	IPS_DELETE="$(set_unique "${IPS_DELETE}")"
	ALIASES_DELETE="$(set_unique "${ALIASES_DELETE}")"

	search_host "cn" "${NAME}"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: Host \"${NAME}\" does not exist"
		exit 6
	fi
	OBJECT_DN="cn=${NAME},${HOST_BASEDN}"
	COMMAND_DN="dn: ${OBJECT_DN}"
	append "${COMMAND_DN}"
	append "changetype: modify"

	# get existing data
	ETHERS_CURRENT="$(ldap_search_getattr ${OBJECT_DN} "cn=${NAME}" macAddress)"
	IPS_CURRENT="$(ldap_search_getattr ${OBJECT_DN} "cn=${NAME}" ipHostNumber)"
	ALIASES_CURRENT="$(ldap_search_getattr ${OBJECT_DN} "cn=${NAME}" cn)"
	#if [ -n "${DEBUG}" ]; then
	#	echo "Initial data"
	#	echo "Ethers-cur: ${ETHERS_CURRENT}"
	#	echo "Ethers-add: ${ETHERS_ADD}"
	#	echo "Ethers-del: ${ETHERS_DELETE}"
	#	echo "IPs-cur: ${IPS_CURRENT}"
	#	echo "IPs-add: ${IPS_ADD}"
	#	echo "IPs-del: ${IPS_DELETE}"
	#	echo "Aliases-cur: ${ALIASES_CURRENT}"
	#	echo "Aliases-add: ${ALIASES_ADD}"
	#	echo "Aliases-del: ${ALIASES_DELETE}"
	#fi

	# build correct data
	ETHERS_ADD="$(set_complement "${ETHERS_ADD} ${ETHERS_CURRENT}" "${ETHERS_CURRENT} ${ETHERS_DELETE}")"
	ETHERS_DELETE=$(set_intersection "${ETHERS_DELETE}" "${ETHERS_CURRENT}")
	ETHERS_FINAL_COUNT=$(($(echo $ETHERS_ADD $ETHERS_CURRENT | ${WC} -w)-$(echo $ETHERS_DELETE | ${WC} -w)))
	# build correct data
	IPS_ADD="$(set_complement "${IPS_ADD} ${IPS_CURRENT}" "${IPS_CURRENT} ${IPS_DELETE}")"
	IPS_DELETE=$(set_intersection "${IPS_DELETE}" "${IPS_CURRENT}")
	IPS_FINAL_COUNT=$(($(echo $IPS_ADD $IPS_CURRENT | ${WC} -w)-$(echo $IPS_DELETE | ${WC} -w)))
	# build correct data
	ALIASES_ADD="$(set_complement "${ALIASES_ADD} ${ALIASES_CURRENT}" "${ALIASES_CURRENT} ${ALIASES_DELETE}")"
	ALIASES_DELETE=$(set_intersection "${ALIASES_DELETE}" "${ALIASES_CURRENT}")
	ALIASES_FINAL_COUNT=$(($(echo $ALIASES_ADD $ALIASES_CURRENT | ${WC} -w)-$(echo $ALIASES_DELETE | ${WC} -w)))

	#if [ -n "${DEBUG}" ]; then
	#	echo "Final data"
	#	echo "Ethers-add: ${ETHERS_ADD}"
	#	echo "Ethers-del: ${ETHERS_DELETE}"
	#	echo "IPs-add: ${IPS_ADD}"
	#	echo "IPs-del: ${IPS_DELETE}"
	#	echo "Aliases-add: ${ALIASES_ADD}"
	#	echo "Aliases-del: ${ALIASES_DELETE}"
	#fi

	if [ -n "$(set_intersection "${ALIASES_DELETE}" "${NAME}")" ]; then
		echo "${modulename}: Cannot delete primary name of ${NAME}! Use rename instead."
		print_usage ${modulename}
		exit 6
	fi

	if [ -n "${ETHERS_ADD}" ]; then
		search_attr "${OBJECT_DN}" "(objectClass=ieee802Device)" "objectClass: ieee802Device" \
			|| append_attrib_add objectClass "ieee802Device"
		for i in ${ETHERS_ADD}; do
			append_attrib_add macAddress "${i}"
		done
	fi
	if [ -n "${ETHERS_DELETE}" ]; then
		for i in ${ETHERS_DELETE}; do
			append_attrib_delete macAddress "${i}"
		done
		if [ $ETHERS_FINAL_COUNT -eq 0 ]; then
			append_attrib_delete objectClass "ieee802Device"
		fi
	fi
	if [ -n "${IPS_ADD}" ]; then
		search_attr "${OBJECT_DN}" "(objectClass=ipHost)" "objectClass: ipHost" \
			|| append_attrib_add objectClass "ipHost"
		for i in ${IPS_ADD}; do
			append_attrib_add ipHostNumber "${i}"
		done
	fi
	if [ -n "${IPS_DELETE}" ]; then
		for i in ${IPS_DELETE}; do
			append_attrib_delete ipHostNumber "${i}"
		done
		if [ $IPS_FINAL_COUNT -eq 0 ]; then
			append_attrib_delete objectClass "ipHost"
		fi
	fi
	if [ -n "${ALIASES_ADD}" ]; then
		for i in ${ALIASES_ADD}; do
			append_attrib_add cn "${i}"
		done
	fi
	if [ -n "${ALIASES_DELETE}" ]; then
		for i in ${ALIASES_DELETE}; do
			append_attrib_delete cn "${i}"
		done
	fi
	# check if we are doing anything
	[ "${COMMAND}" == "${COMMAND_DN}" ] && unset COMMAND

	[ -n "${NEWNAME}" ] && append "\n\ndn: cn=${NAME},${HOST_BASEDN}\nchangetype: modrdn\nnewrdn: cn=${NEWNAME}\n"

	#echo "${COMMAND}"
	runmodify
}
