#!/usr/bin/false
# $Header: /code/convert/cvsroot/infrastructure/diradm/src/diradm.shadow.sh.in,v 1.12 2007/03/22 17:21:20 robbat2 Exp $
# vim: ts=4 sts=4 noexpandtab sw=4 ft=sh syntax=sh:
# This contains all of the functions specific to the passwd sub-system.

chage() {
	LISTONLY="0"
	BRIEF="0"
	[ -z "${modulename}" ] && modulename="chage"
	unset OPTION OPTARG OPTIND
	while getopts "lm:M:W:I:E:d:" OPTION; do
		case "${OPTION}" in
			l) LISTONLY="1" ; BRIEF="0" ;;
			S) LISTONLY="1" ; BRIEF="1" ;;
			m) MINDAYS="${OPTARG}";;
			M) MAXDAYS="${OPTARG}";;
			W) WARNDAYS="${OPTARG}";;
			I) INACTIVEDAYS="${OPTARG}";;
			E) ACCOUNTEXPIRY="${OPTARG}";;
			d) LASTCHANGE="${OPTARG}";;
		esac
	done
	shift $((${OPTIND} - 1))
	if [ "${#}" -ne 1 ]; then
		print_usage ${modulename}
		exit 2
	else
		LOGIN="${1}"
	fi
	ALLOWED=0
	[ "x${LISTONLY}" == 'x1' -a "$(${WHOAMI})" == "${LOGIN}" ] && ALLOWED=1
	[ "${UID}" -eq "0" ] && ALLOWED=1
	if [ ${ALLOWED} -ne 1 ]; then
		#You must be root to change password aging information, or view it"
		#for any user other than yourself."
		echo "${modulename}: permission denied"
		exit 1
	fi
	search_user "uid" "${LOGIN}"
	if [ "$?" -ne 0 ]; then
		echo "${modulename}: unknown user: ${LOGIN}"
		exit 1
	fi
	OLDMINDAYS=$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" shadowMin)
	[[ -z "${OLDMINDAYS}" ]] && OLDMINDAYS=0
	OLDMAXDAYS=$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" shadowMax)
	[[ -z "${OLDMAXDAYS}" ]] && OLDMAXDAYS=0
	OLDWARNDAYS=$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" shadowWarning)
	[[ -z "${OLDWARNDAYS}" ]] && OLDWARNDAYS=0
	OLDINACTIVEDAYS=$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" shadowInactive)
	[[ -z "${OLDINACTIVEDAYS}" ]] && OLDINACTIVEDAYS=0
	OLDACCOUNTEXPIRY=$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" shadowExpire)
	[[ -z "${OLDACCOUNTEXPIRY}" ]] && OLDACCOUNTEXPIRY=0
	OLDLASTCHANGE=$(ldap_search_getattr "${USER_BASEDN}" "uid=${LOGIN}" shadowLastChange)
	[[ -z "${OLDLASTCHANGE}" ]] && OLDLASTCHANGE=0

	if [[ "x${LISTONLY}" == 'x1' ]]; then
		if [ ${OLDLASTCHANGE} -le 0 -o ${OLDMAXDAYS} -ge 10000 -o ${OLDMAXDAYS} -le 0 ]; then
			PASSWORDEXPIRY_STRING="Never"
		else
			PASSWORDEXPIRY_STRING="$(days_to_date $((${OLDLASTCHANGE} + ${OLDMAXDAYS})) '+%b %d, %Y')"
		fi
		if [ ${OLDLASTCHANGE} -le 0 -o ${OLDMAXDAYS} -ge 10000 -o ${OLDMAXDAYS} -le 0 -o ${OLDINACTIVEDAYS} -le 0 ]; then
			PASSWORDINACTIVE_STRING="Never"
		else
			PASSWORDINACTIVE_STRING="$(days_to_date $((${OLDLASTCHANGE} + ${OLDMAXDAYS} + ${OLDINACTIVEDAYS})) '+%b %d, %Y')"
		fi
		if [[ ${OLDACCOUNTEXPIRY} -le 0  ]]; then
			ACCOUNTEXPIRY_STRING="Never"
		else
			ACCOUNTEXPIRY_STRING="$(days_to_date ${OLDACCOUNTEXPIRY} +'%b %d, %Y')"
		fi
		if [[ "x${BRIEF}" == "x0" ]]; then
			echo -e "Last password Change:\t$(days_to_date ${OLDLASTCHANGE} +'%b %d, %Y')"
			echo -e "Password Expires:\t${PASSWORDEXPIRY_STRING}"
			echo -e "Password Inactive:\t${PASSWORDINACTIVE_STRING}"
			echo -e "Account Expires:\t${ACCOUNTEXPIRY_STRING}"
			echo -e "Minimum number of days between password change:\t${OLDMINDAYS}"
			echo -e "Maximum number of days between password change:\t${OLDMAXDAYS}"
			echo -e "Number of days of warning before password expires:\t${OLDWARNDAYS}"
			#echo -e "Inactive:\t${OLDINACTIVEDAYS}"
			#echo -e "Last Change:\t${LASTCHANGE}" # raw
		else 
			echo "${USER} ${STATUS} (days_to_date ${OLDLASTCHANGE} +'%m/%d/%Y') ${OLDMINDAYS} ${OLDMAXDAYS} ${OLDWARNDAYS} ${OLDINACTIVEDAYS}"
		fi
# shadowLastChange - The number of days (since January 1, 1970) since the password was last changed.
# shadowMin - The number of days before password may be changed (0 indicates it may be changed at any time)
# shadowMax - The number of days after which password must be changed (99999 indicates user can keep his or her password unchanged for many, many years)
# shadowWarning - The number of days to warn user of an expiring password (7 for a full week)
# shadowInactive - The number of days after password expires that account is disabled
# shadowExpire - The number of days since January 1, 1970 that an account has been disabled
# shadowFlag - A reserved field for possible future use
		exit 0
	fi
	COMMAND_DN="dn: uid=${LOGIN},${USER_BASEDN}"
	append "${COMMAND_DN}"
	isinteger "${LASTCHANGE}" || LASTCHANGE="$(date_to_days "${LASTCHANGE}")"
	isinteger "${ACCOUNTEXPIRY}" || ACCOUNTEXPIRY="$(date_to_days "${ACCOUNTEXPIRY}")"
	
	[ -n "${LASTCHANGE}" -a "${LASTCHANGE}" -ne "${OLDLASTCHANGE}" ] && append_attrib_replace "shadowLastChange" "${LASTCHANGE}"
	[ -n "${MINDAYS}" -a "${MINDAYS}" -ne "${OLDMINDAYS}" ] && append_attrib_replace "shadowMin" "${MINDAYS}"
	[ -n "${MAXDAYS}" -a "${MAXDAYS}" -ne "${OLDMAXDAYS}" ] && append_attrib_replace "shadowMax" "${MAXDAYS}"
	[ -n "${WARNDAYS}" -a "${WARNDAYS}" -ne "${OLDWARNDAYS}" ] && append_attrib_replace "shadowWarning" "${WARNDAYS}"
	[ -n "${INACTIVEDAYS}" -a "${INACTIVEDAYS}" -ne "${OLDINACTIVEDAYS}" ] && append_attrib_replace "shadowInactive" "${INACTIVEDAYS}"
	[ -n "${ACCOUNTEXPIRY}" -a "${ACCOUNTEXPIRY}" -ne "${OLDACCOUNTEXPIRY}" ] && append_attrib_replace "shadowExpire" "${ACCOUNTEXPIRY}"
	[ "${COMMAND}" == "${COMMAND_DN}" ] && unset COMMAND
	runmodify
}

passwd() {
	ORIGINAL_ARGS="$@"
	[[ -z "${modulename}" ]] && modulename="passwd"
	MODE=""
	unset OPTION OPTARG OPTIND
	while getopts "fsgrRx:n:w:i:ludSep:" OPTION; do
		CURRENT_MODE="${MODE}"
		case "${OPTION}" in
			# external stuff
			f) MODE="chfn" ;;
			s) MODE="chsh" ;;
			x) MODE="chage" ; CHAGE_MAX="${OPTARG}" ;;
			n) MODE="chage" ; CHAGE_MIN="${OPTARG}" ;;
			w) MODE="chage" ; CHAGE_WARN="${OPTARG}" ;;
			i) MODE="chage" ; CHAGE_INACTIVE="${OPTARG}" ;;
			e) MODE="chage" ; CHAGE_LASTCHANGE="0"  ;;
			S) MODE="chage" ; CMD="status" ;;
			l) MODE="passwd" ; CMD="lock" ;;
			u) MODE="passwd" ; CMD="unlock" ;;
			d) MODE="passwd" ; CMD="set" ; PASSWD="" ;;
			p) MODE="passwd" ; CMD="set" ; PASSWD="${OPTARG}" ;;
			*) print_usage ${modulename} ; exit 1 ;;
		esac
		if [ -n "${CURRENT_MODE}" -a "${MODE}" != "${CURRENT_MODE}" ]; then
			echo "${modulename}: Conflicting modes"
			print_usage ${MODE} ${CURRENT_MODE}
			exit 3
		fi
	done
	shift $((${OPTIND} - 1))
	# TODO is this always safe?
	if [ "${#}" -ne 1 -o -z "${MODE}" ]; then
		print_usage ${modulename}
		exit 2
	fi

	# chsh/chfn are both from diradm.user
	if [ "x${MODE}" = "xchfn" -o "x${MODE}" = "xchsh" ]; then
		source ${libexecdir}/diradm.user.sh
		${MODE}
		exit $?
	fi
	# chage is from diradm.shadow (this file)
	if [ "x${MODE}" = "xchage" ]; then
		args=""
		[ -n "${CHAGE_MIN}" ] && args="${args} -m ${CHAGE_MIN}"
		[ -n "${CHAGE_MAX}" ] && args="${args} -M ${CHAGE_MAX}"
		[ -n "${CHAGE_WARN}" ] && args="${args} -W ${CHAGE_WARN}"
		[ -n "${CHAGE_INACTIVE}" ] && args="${args} -I ${CHAGE_INACTIVE}"
		[ -n "${CHAGE_LASTCHANGE}" ] && args="${args} -d ${CHAGE_MIN}"
		# disable changes if we are displaying status
		[ "x${CMD}" = "xstatus" ] && args="-S"
		chage ${args}
		exit $?
	fi
	if [ "x${MODE}" = "passwd" ]; then
		source ${libexecdir}/diradm.user.sh
		args=""
		case ${CMD} in
			lock) args="${args} -L" ;;
			unlock) args="${args} -U" ;;
			set) args="${args} -p '${PASSWD}'" ;;
		esac
		usermod ${args}
		exit $?
	fi
	
	echo "You shouldn't have gotten here. Please report this bug. ${FUNCNAME}:${LINENO}"
	exit 99
}
