import sys

if sys.platform == "darwin":
    from collections.abc import Callable
    from typing import Final, NamedTuple, TypeVar
    from typing_extensions import ParamSpec

    from psutil._common import (
        AccessDenied as AccessDenied,
        NoSuchProcess as NoSuchProcess,
        ZombieProcess as ZombieProcess,
        conn_tmap as conn_tmap,
        conn_to_ntuple as conn_to_ntuple,
        debug as debug,
        isfile_strict as isfile_strict,
        memoize_when_activated as memoize_when_activated,
        parse_environ_block as parse_environ_block,
        usage_percent as usage_percent,
    )

    from . import _common, _psposix, _psutil_osx

    _P = ParamSpec("_P")
    _R = TypeVar("_R")

    __extra__all__: Final[list[str]]
    PAGESIZE: Final[int]
    AF_LINK: Final[int]
    TCP_STATUSES: Final[dict[int, str]]
    PROC_STATUSES: Final[dict[int, str]]
    kinfo_proc_map: Final[dict[str, int]]
    pidtaskinfo_map: Final[dict[str, int]]

    class scputimes(NamedTuple):
        user: float
        nice: float
        system: float
        idle: float

    class svmem(NamedTuple):
        total: int
        available: int
        percent: float
        used: int
        free: int
        active: int
        inactive: int
        wired: int

    class pmem(NamedTuple):
        rss: int
        vms: int
        pfaults: int
        pageins: int

    class pfullmem(NamedTuple):
        rss: int
        vms: int
        pfaults: int
        pageins: int
        uss: int

    def virtual_memory() -> svmem: ...
    def swap_memory() -> _common.sswap: ...
    def cpu_times() -> scputimes: ...
    def per_cpu_times() -> list[scputimes]: ...
    def cpu_count_logical() -> int | None: ...
    def cpu_count_cores() -> int | None: ...
    def cpu_stats() -> _common.scpustats: ...
    def cpu_freq() -> list[_common.scpufreq]: ...

    disk_usage = _psposix.disk_usage
    disk_io_counters = _psutil_osx.disk_io_counters
    def disk_partitions(all: bool = False) -> list[_common.sdiskpart]: ...
    def sensors_battery() -> _common.sbattery | None: ...

    net_io_counters = _psutil_osx.net_io_counters
    net_if_addrs = _psutil_osx.net_if_addrs
    def net_connections(kind: str = "inet") -> list[_common.sconn]: ...
    def net_if_stats() -> dict[str, _common.snicstats]: ...
    def boot_time() -> float: ...
    INIT_BOOT_TIME: float
    def adjust_proc_create_time(ctime: float) -> float: ...
    def users() -> list[_common.suser]: ...
    def pids() -> list[int]: ...
    pid_exists = _psposix.pid_exists
    def wrap_exceptions(fun: Callable[_P, _R]) -> Callable[_P, _R]: ...

    class Process:
        __slots__ = ["_cache", "_name", "_ppid", "pid"]
        pid: int
        def __init__(self, pid: int) -> None: ...
        def oneshot_enter(self) -> None: ...
        def oneshot_exit(self) -> None: ...
        def name(self) -> str: ...
        def exe(self) -> str: ...
        def cmdline(self) -> list[str]: ...
        def environ(self) -> dict[str, str]: ...
        def ppid(self) -> int: ...
        def cwd(self) -> str: ...
        def uids(self) -> _common.puids: ...
        def gids(self) -> _common.puids: ...
        def terminal(self) -> str | None: ...
        def memory_info(self) -> pmem: ...
        def memory_full_info(self) -> pfullmem: ...
        def cpu_times(self) -> _common.pcputimes: ...
        def create_time(self, monotonic: bool = False) -> float: ...
        def num_ctx_switches(self) -> _common.pctxsw: ...
        def num_threads(self) -> int: ...
        def open_files(self) -> list[_common.popenfile]: ...
        def net_connections(self, kind: str = "inet") -> list[_common.pconn]: ...
        def num_fds(self) -> int: ...
        def wait(self, timeout: float | None = None) -> int | None: ...
        def nice_get(self) -> int: ...
        def nice_set(self, value: int) -> None: ...
        def status(self) -> str: ...
        def threads(self) -> list[_common.pthread]: ...
