import sys

if sys.platform == "linux":
    from collections.abc import Sequence
    from typing import Final

    RLIMIT_AS: Final[int]
    RLIMIT_CORE: Final[int]
    RLIMIT_CPU: Final[int]
    RLIMIT_DATA: Final[int]
    RLIMIT_FSIZE: Final[int]
    RLIMIT_MEMLOCK: Final[int]
    RLIMIT_NOFILE: Final[int]
    RLIMIT_NPROC: Final[int]
    RLIMIT_RSS: Final[int]
    RLIMIT_STACK: Final[int]
    RLIMIT_LOCKS: Final[int]
    RLIMIT_MSGQUEUE: Final[int]
    RLIMIT_NICE: Final[int]
    RLIMIT_RTPRIO: Final[int]
    RLIMIT_RTTIME: Final[int]
    RLIMIT_SIGPENDING: Final[int]
    RLIM_INFINITY: Final[int]

    def getpagesize() -> int: ...
    def net_if_addrs() -> list[tuple[str, int, str, str | None, str | None, str | None]]: ...
    def net_if_flags(nic_name: str, /) -> list[str]: ...
    def net_if_is_running(nic_name: str, /) -> bool: ...
    def net_if_mtu(nic_name: str, /) -> int: ...
    def proc_priority_get(pid: int, /) -> int: ...
    def proc_priority_set(pid: int, priority: int, /) -> None: ...
    def users() -> list[tuple[str, str, str, float, int]]: ...

    version: Final[int]
    DUPLEX_FULL: Final[int]
    DUPLEX_HALF: Final[int]
    DUPLEX_UNKNOWN: Final[int]

    def proc_ioprio_get(pid: int, /) -> tuple[int, int]: ...
    def proc_ioprio_set(pid: int, ioclass: int, iodata: int, /) -> None: ...
    def proc_cpu_affinity_get(pid: int, /) -> list[int]: ...
    def proc_cpu_affinity_set(pid: int, cpu_set: Sequence[int], /) -> None: ...
    def disk_partitions(mtab_path: str, /) -> list[tuple[str, str, str, str]]: ...
    def net_if_duplex_speed(nic_name: str, /) -> tuple[int, int]: ...  # It's actually list of 2 elements
    def linux_sysinfo() -> tuple[int, int, int, int, int, int, int]: ...
    def check_pid_range(pid: int, /) -> None: ...
    def set_debug(value: bool, /) -> None: ...
