// This file is part of libigl, a simple c++ geometry processing library.
//
// Copyright (C) 2023 Alec Jacobson <alecjacobson@gmail.com>
//
// This Source Code Form is subject to the terms of the Mozilla Public License
// v. 2.0. If a copy of the MPL was not distributed with this file, You can
// obtain one at http://mozilla.org/MPL/2.0/.
#include "isolines.h"
#include "isolines_intrinsic.h"


template <
  typename DerivedV,
  typename DerivedF,
  typename DerivedS,
  typename Derivedvals,
  typename DerivediV,
  typename DerivediE,
  typename DerivedI>
void igl::isolines(
  const Eigen::MatrixBase<DerivedV> & V,
  const Eigen::MatrixBase<DerivedF> & F,
  const Eigen::MatrixBase<DerivedS> & S,
  const Eigen::MatrixBase<Derivedvals> & vals,
  Eigen::PlainObjectBase<DerivediV> & iV,
  Eigen::PlainObjectBase<DerivediE> & iE,
  Eigen::PlainObjectBase<DerivedI> & I)
{
  using Scalar = typename DerivedS::Scalar;
  using MatrixXS = Eigen::Matrix<Scalar,Eigen::Dynamic,Eigen::Dynamic>;

  MatrixXS iB;
  Eigen::VectorXi iFI;
  isolines_intrinsic(F,S,vals,iB,iFI,iE,I);
  iV.resize(iB.rows(),V.cols());
  for(int i = 0;i<iB.rows();i++)
  {
    iV.row(i) = 
      iB(i,0)*V.row(F(iFI(i),0))+
      iB(i,1)*V.row(F(iFI(i),1))+
      iB(i,2)*V.row(F(iFI(i),2));
  }
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template void igl::isolines<Eigen::Matrix<double, -1, -1, 0, -1, -1>, Eigen::Matrix<int, -1, -1, 0, -1, -1>, Eigen::Matrix<double, -1, 1, 0, -1, 1>, Eigen::Matrix<double, -1, 1, 0, -1, 1>, Eigen::Matrix<double, -1, -1, 0, -1, -1>, Eigen::Matrix<int, -1, -1, 0, -1, -1>, Eigen::Matrix<int, -1, 1, 0, -1, 1> >(Eigen::MatrixBase<Eigen::Matrix<double, -1, -1, 0, -1, -1> > const&, Eigen::MatrixBase<Eigen::Matrix<int, -1, -1, 0, -1, -1> > const&, Eigen::MatrixBase<Eigen::Matrix<double, -1, 1, 0, -1, 1> > const&, Eigen::MatrixBase<Eigen::Matrix<double, -1, 1, 0, -1, 1> > const&, Eigen::PlainObjectBase<Eigen::Matrix<double, -1, -1, 0, -1, -1> >&, Eigen::PlainObjectBase<Eigen::Matrix<int, -1, -1, 0, -1, -1> >&, Eigen::PlainObjectBase<Eigen::Matrix<int, -1, 1, 0, -1, 1> >&);
#endif
