#!/bin/sh

tool=${0##*/}

if [ "${tool}" = "javaws" ] && [ -x "/usr/bin/itweb-javaws" ]; then
	exec "/usr/bin/itweb-javaws" "${@}"
fi

user_vm="${HOME}/.gentoo/java-config-2/current-user-vm"
system_vm="/etc/java-config-2/current-system-vm"

# Try GENTOO_VM
if [ -n "${GENTOO_VM}" ]; then
	vmpath="/usr/lib/jvm/${GENTOO_VM}"
# Then user VM
elif [ -h "${user_vm}" ]; then
	vmpath=$(readlink "${user_vm}")
# And fall back to the system VM
else
	vmpath=$(readlink "${system_vm}")
fi

vm_handle=${vmpath##*/}

toolpath=$(
	export PATH=
        # shellcheck disable=SC1090
	. "/usr/share/java-config-2/vm/${vm_handle}" 2> /dev/null
	: ${PATH:=${vmpath}/bin:${vmpath}/jre/bin}
	command -v "${tool}" 2> /dev/null
)

if [ -x "${toolpath}" ]; then
	exec "${toolpath}" "${@}"
else
	if [ ! -d "${vmpath}" ]; then
		echo "* Home for VM '${vm_handle}' does not exist: ${vmpath}" >&2
		if [ -n "${GENTOO_VM}" ]; then
			echo "* Invalid value for GENTOO_VM: ${GENTOO_VM}"
		elif [ -h "${user_vm}" ]; then
			echo "* Invalid User VM: ${vm_handle}" >&2
		else
			echo "* Invalid System VM: ${vm_handle}" >&2
		fi
	else
		if [ "${tool}" = "run-java-tool.bash" ]; then
			echo "* run-java-tool was invoked directly" >&2
			echo "* run-java-tool should only be used via symlinks to it" >&2
		else
			echo "* ${tool} is not available for ${vm_handle} on $(uname -m)" >&2
			echo "* IMPORTANT: some Java tools are not available on some VMs or some architectures" >&2
			if [ "$(id -u)" != 0 ] && [ -n "${DISPLAY}" ] && command -v notify-send > /dev/null; then
				notify-send -i java-icon48 "Gentoo Java Launcher" "<b>${tool}</b> is not available for ${vm_handle}
<a href=\"https://wiki.gentoo.org/wiki/Java\">Gentoo Java User Guide</a>"
			fi
		fi
	fi
	exit 1
fi
