/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * RDMResponseCodes.h
 * Enums representing the state of a response. This is generated from the proto
 * file, so that we don't have to make the Ola.pb.h file public.
 * Copyright (C) 2010 Simon Newton
 *
 * This file has been autogenerated by make_rdm_codes.sh, DO NOT EDIT.
 */

/**
 * @addtogroup rdm_helpers
 * @{
 * @file RDMResponseCodes.h
 * @brief Enums representing the states of a response. This is generated from
 * the proto file.
 * @}
 */
#ifndef INCLUDE_OLA_RDM_RDMRESPONSECODES_H_
#define INCLUDE_OLA_RDM_RDMRESPONSECODES_H_

namespace ola {
namespace rdm {

/**
 * @brief RDM Status Codes.
 *
 * The status codes indicates the outcome of an RDM Request. The two most
 * common status codes are RDM_COMPLETED_OK and RDM_WAS_BROADCAST. The other
 * codes generally indicate some sort of failure.
 */
typedef enum {
  RDM_COMPLETED_OK = 0,
  RDM_WAS_BROADCAST = 1,
  RDM_FAILED_TO_SEND = 2,
  RDM_TIMEOUT = 3,
  RDM_INVALID_RESPONSE = 4,
  RDM_UNKNOWN_UID = 5,
  RDM_CHECKSUM_INCORRECT = 6,
  RDM_TRANSACTION_MISMATCH = 7,
  RDM_SUB_DEVICE_MISMATCH = 8,
  RDM_SRC_UID_MISMATCH = 9,
  RDM_DEST_UID_MISMATCH = 10,
  RDM_WRONG_SUB_START_CODE = 11,
  RDM_PACKET_TOO_SHORT = 12,
  RDM_PACKET_LENGTH_MISMATCH = 13,
  RDM_PARAM_LENGTH_MISMATCH = 14,
  RDM_INVALID_COMMAND_CLASS = 15,
  RDM_COMMAND_CLASS_MISMATCH = 16,
  RDM_INVALID_RESPONSE_TYPE = 17,
  RDM_PLUGIN_DISCOVERY_NOT_SUPPORTED = 18,
  RDM_DUB_RESPONSE = 19,
} RDMStatusCode;

/**
 * @deprecated Use RDMStatusCode instead.
 */
typedef RDMStatusCode rdm_response_code;

/**
 * @brief RDM response types
 */
typedef enum {
  RDM_ACK = 0,
  RDM_ACK_TIMER = 1,
  RDM_NACK_REASON = 2,
} rdm_response_type;
}  // namespace rdm
}  // namespace ola
#endif  // INCLUDE_OLA_RDM_RDMRESPONSECODES_H_
