# SPDX-License-Identifier: Apache-2.0
# Copyright 2012-2021 The Meson development team
# Copyright © 2021-2023 Intel Corporation

from __future__ import annotations

"""base classes providing no-op functionality.."""

import os
import typing as T

from .. import mlog

__all__ = ['BuildDirLock']

# This needs to be inherited by the specific implementations to make type
# checking happy
class BuildDirLock:

    def __init__(self, builddir: str) -> None:
        self.lockfilename = os.path.join(builddir, 'meson-private/meson.lock')

    def __enter__(self) -> None:
        mlog.debug('Calling the no-op version of BuildDirLock')

    def __exit__(self, *args: T.Any) -> None:
        pass
