%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4.2
%% Purpose: Encoding and decoding of the types in OTP-PKIX.

-module('OTP-PKIX').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("OTP-PKIX.hrl").
-asn1_info([{vsn,'5.4.2'},
            {module,'OTP-PKIX'},
            {options,[{i,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1"},
 {outdir,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/var/tmp/portage/dev-lang/erlang-28.3/work/otp-OTP-28.3/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_OTPCertificate/2,
enc_OTPTBSCertificate/2,
'enc_OTP-DSA-Params-Or-NULL'/2,
enc_OTPName/2,
enc_RDNSequence/2,
enc_OTPRelativeDistinguishedName/2,
'enc_OTP-X520countryName'/2,
'enc_OTP-emailAddress'/2,
enc_HashSingleAttribute/2,
enc_HashRDNSequence/2,
enc_HashRelativeDistinguishedName/2,
enc_OTPCertificatePolicies/2,
enc_OTPPolicyInformation/2,
enc_CertPolicyId/2,
enc_OTPPolicyQualifierInfo/2,
enc_CPSuri/2,
enc_OTPUserNotice/2,
enc_OTPDisplayText/2,
enc_Extensions/2,
enc_OTPExtension/2
]).

-export([
dec_OTPCertificate/2,
dec_OTPTBSCertificate/2,
'dec_OTP-DSA-Params-Or-NULL'/2,
dec_OTPName/2,
dec_RDNSequence/2,
dec_OTPRelativeDistinguishedName/2,
'dec_OTP-X520countryName'/2,
'dec_OTP-emailAddress'/2,
dec_HashSingleAttribute/2,
dec_HashRDNSequence/2,
dec_HashRelativeDistinguishedName/2,
dec_OTPCertificatePolicies/2,
dec_OTPPolicyInformation/2,
dec_CertPolicyId/2,
dec_OTPPolicyQualifierInfo/2,
dec_CPSuri/2,
dec_OTPUserNotice/2,
dec_OTPDisplayText/2,
dec_Extensions/2,
dec_OTPExtension/2
]).

-export([
'enc_otp-sa-dsaWithSHA1'/3,
'enc_otp-at-x520countryName'/3,
'enc_otp-at-emailAddress'/3,
'enc_pqid-cps'/3,
'enc_pqid-unotice'/3,
'enc_otp-sa-dsaWithSHA1_smimeCaps'/3,
enc_OTPTBSCertificate_smimeCaps/3,
enc_OTPCertificate_smimeCaps/3
]).

-export([
'dec_otp-sa-dsaWithSHA1'/3,
'dec_otp-at-x520countryName'/3,
'dec_otp-at-emailAddress'/3,
'dec_pqid-cps'/3,
'dec_pqid-unotice'/3,
'dec_otp-sa-dsaWithSHA1_smimeCaps'/3,
dec_OTPTBSCertificate_smimeCaps/3,
dec_OTPCertificate_smimeCaps/3
]).

-export([
getenc_OTPSignatureAlgorithms/1,
getenc_OTPSignatureAlgs/1,
getenc_OTPSupportedAttributes/1,
getenc_PolicyQualifierId/1,
getenc_internal_object_set_argument_9/1,
getenc_internal_object_set_argument_7/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_3/1,
getenc_internal_object_set_argument_2/1
]).

-export([
getdec_OTPSignatureAlgorithms/1,
getdec_OTPSignatureAlgs/1,
getdec_OTPSupportedAttributes/1,
getdec_PolicyQualifierId/1,
getdec_internal_object_set_argument_9/1,
getdec_internal_object_set_argument_7/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_3/1,
getdec_internal_object_set_argument_2/1
]).

-export([info/0]).

-export([
decode_TBSCert_exclusive/1
]).

-export([decode_part/2]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_partial_incomplete(Type, Data0, Pattern) ->
  {Data,RestBin} =
    decode_primitive_incomplete(Pattern, Data0),
  try {ok,decode_partial_inc_disp(Type, Data)}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_part(Type, Data0) when is_binary(Data0) ->
  try {ok,decode_inc_disp(Type, element(1, ber_decode_nif(Data0)))}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end;
decode_part(Type, Data0) ->
  try {ok,decode_inc_disp(Type, Data0)}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

decode_partial_inc_disp('OTPCertificate',Data) ->
  'dec-inc-OTPCertificate'(Data).
encode_disp('OTPCertificate', Data) -> enc_OTPCertificate(Data);
encode_disp('OTPTBSCertificate', Data) -> enc_OTPTBSCertificate(Data);
encode_disp('OTP-DSA-Params-Or-NULL', Data) -> 'enc_OTP-DSA-Params-Or-NULL'(Data);
encode_disp('OTPName', Data) -> enc_OTPName(Data);
encode_disp('RDNSequence', Data) -> enc_RDNSequence(Data);
encode_disp('OTPRelativeDistinguishedName', Data) -> enc_OTPRelativeDistinguishedName(Data);
encode_disp('OTP-X520countryName', Data) -> 'enc_OTP-X520countryName'(Data);
encode_disp('OTP-emailAddress', Data) -> 'enc_OTP-emailAddress'(Data);
encode_disp('HashSingleAttribute', Data) -> enc_HashSingleAttribute(Data);
encode_disp('HashRDNSequence', Data) -> enc_HashRDNSequence(Data);
encode_disp('HashRelativeDistinguishedName', Data) -> enc_HashRelativeDistinguishedName(Data);
encode_disp('OTPCertificatePolicies', Data) -> enc_OTPCertificatePolicies(Data);
encode_disp('OTPPolicyInformation', Data) -> enc_OTPPolicyInformation(Data);
encode_disp('CertPolicyId', Data) -> enc_CertPolicyId(Data);
encode_disp('OTPPolicyQualifierInfo', Data) -> enc_OTPPolicyQualifierInfo(Data);
encode_disp('CPSuri', Data) -> enc_CPSuri(Data);
encode_disp('OTPUserNotice', Data) -> enc_OTPUserNotice(Data);
encode_disp('OTPDisplayText', Data) -> enc_OTPDisplayText(Data);
encode_disp('Extensions', Data) -> enc_Extensions(Data);
encode_disp('OTPExtension', Data) -> enc_OTPExtension(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('OTPCertificate', Data) -> dec_OTPCertificate(Data);
decode_disp('OTPTBSCertificate', Data) -> dec_OTPTBSCertificate(Data);
decode_disp('OTP-DSA-Params-Or-NULL', Data) -> 'dec_OTP-DSA-Params-Or-NULL'(Data);
decode_disp('OTPName', Data) -> dec_OTPName(Data);
decode_disp('RDNSequence', Data) -> dec_RDNSequence(Data);
decode_disp('OTPRelativeDistinguishedName', Data) -> dec_OTPRelativeDistinguishedName(Data);
decode_disp('OTP-X520countryName', Data) -> 'dec_OTP-X520countryName'(Data);
decode_disp('OTP-emailAddress', Data) -> 'dec_OTP-emailAddress'(Data);
decode_disp('HashSingleAttribute', Data) -> dec_HashSingleAttribute(Data);
decode_disp('HashRDNSequence', Data) -> dec_HashRDNSequence(Data);
decode_disp('HashRelativeDistinguishedName', Data) -> dec_HashRelativeDistinguishedName(Data);
decode_disp('OTPCertificatePolicies', Data) -> dec_OTPCertificatePolicies(Data);
decode_disp('OTPPolicyInformation', Data) -> dec_OTPPolicyInformation(Data);
decode_disp('CertPolicyId', Data) -> dec_CertPolicyId(Data);
decode_disp('OTPPolicyQualifierInfo', Data) -> dec_OTPPolicyQualifierInfo(Data);
decode_disp('CPSuri', Data) -> dec_CPSuri(Data);
decode_disp('OTPUserNotice', Data) -> dec_OTPUserNotice(Data);
decode_disp('OTPDisplayText', Data) -> dec_OTPDisplayText(Data);
decode_disp('Extensions', Data) -> dec_Extensions(Data);
decode_disp('OTPExtension', Data) -> dec_OTPExtension(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  OTPCertificate
%%================================
enc_OTPCertificate(Val) ->
    enc_OTPCertificate(Val, [<<48>>]).

enc_OTPCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PKIX:OTPTBSCertificate
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_OTPTBSCertificate'(Cindex1, [<<48>>]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes2,EncLen2} = 'enc_OTPCertificate_signatureAlgorithm'(Cindex2, [<<48>>]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_unnamed_bit_string(Cindex3, [<<3>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OTPCertificate_signatureAlgorithm
%%================================
enc_OTPCertificate_signatureAlgorithm(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PKIX':'getenc_internal_object_set_argument_9'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPCertificate(Tlv) ->
   dec_OTPCertificate(Tlv, [16]).

dec_OTPCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PKIX:OTPTBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_OTPTBSCertificate'(V1, [16]),

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_OTPCertificate_signatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OTPCertificate',Term1,Term2,Term3},
Res1.
'dec_OTPCertificate_signatureAlgorithm'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PKIX':'getdec_internal_object_set_argument_9'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPCertificate_signatureAlgorithm',Term1,Term2},
Res1.


%%================================
%%  OTPTBSCertificate
%%================================
enc_OTPTBSCertificate(Val) ->
    enc_OTPTBSCertificate(Val, [<<48>>]).

enc_OTPTBSCertificate(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4,Cindex5,Cindex6,Cindex7,Cindex8,Cindex9,Cindex10} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case is_default_1(Cindex1) of
true -> {[],0};
false ->
encode_integer(Cindex1, [{v1,0},{v2,1},{v3,2}], [<<2>>,<<160>>])
       end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute signature(3) with type SEQUENCE
%%-------------------------------------------------
   {EncBytes3,EncLen3} = 'enc_OTPTBSCertificate_signature'(Cindex3, [<<48>>]),

%%-------------------------------------------------
%% attribute issuer(4)   External OTP-PKIX:OTPName
%%-------------------------------------------------
   {EncBytes4,EncLen4} = 'enc_OTPName'(Cindex4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit-2009:Validity
%%-------------------------------------------------
   {EncBytes5,EncLen5} = 'PKIX1Explicit-2009':'enc_Validity'(Cindex5, [<<48>>]),

%%-------------------------------------------------
%% attribute subject(6)   External OTP-PKIX:OTPName
%%-------------------------------------------------
   {EncBytes6,EncLen6} = 'enc_OTPName'(Cindex6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External PKIX1Explicit-2009:SubjectPublicKeyInfo
%%-------------------------------------------------
   {EncBytes7,EncLen7} = 'PKIX1Explicit-2009':'enc_SubjectPublicKeyInfo'(Cindex7, [<<48>>]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes8,EncLen8} =  case Cindex8 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex8, [<<129>>])
       end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
   {EncBytes9,EncLen9} =  case Cindex9 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_unnamed_bit_string(Cindex9, [<<130>>])
       end,

%%-------------------------------------------------
%% attribute extensions(10) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes10,EncLen10} =  case Cindex10 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OTPTBSCertificate_extensions'(Cindex10, [<<48>>,<<163>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6, EncBytes7, EncBytes8, EncBytes9, EncBytes10],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6 + EncLen7 + EncLen8 + EncLen9 + EncLen10,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OTPTBSCertificate_signature
%%================================
enc_OTPTBSCertificate_signature(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'OTP-PKIX':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OTPTBSCertificate_extensions
%%================================
enc_OTPTBSCertificate_extensions(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_OTPTBSCertificate_extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPTBSCertificate_extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OTPTBSCertificate_extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OTPTBSCertificate_extensions_Extension'(H, [<<48>>]),
   'enc_OTPTBSCertificate_extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  OTPTBSCertificate_extensions_Extension
%%================================
enc_OTPTBSCertificate_extensions_Extension(Val, TagIn) ->
   {_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPTBSCertificate(Tlv) ->
   dec_OTPTBSCertificate(Tlv, [16]).

dec_OTPTBSCertificate(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute version(1) with type INTEGER DEFAULT = 0
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{131072,V1}|TempTlv2] ->
    {begin
Val1 = decode_integer(V1, [2]),
number2name(Val1, [{v1,0},{v2,1},{v3,2}])
end
, TempTlv2};
    _ ->
        {0,Tlv1}
end,

%%-------------------------------------------------
%% attribute serialNumber(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_integer(V2, [2]),

%%-------------------------------------------------
%% attribute signature(3) with type SEQUENCE
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = 'dec_OTPTBSCertificate_signature'(V3, [16]),

%%-------------------------------------------------
%% attribute issuer(4)   External OTP-PKIX:OTPName
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = 'dec_OTPName'(V4, []),

%%-------------------------------------------------
%% attribute validity(5)   External PKIX1Explicit-2009:Validity
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = 'PKIX1Explicit-2009':'dec_Validity'(V5, [16]),

%%-------------------------------------------------
%% attribute subject(6)   External OTP-PKIX:OTPName
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = 'dec_OTPName'(V6, []),

%%-------------------------------------------------
%% attribute subjectPublicKeyInfo(7)   External PKIX1Explicit-2009:SubjectPublicKeyInfo
%%-------------------------------------------------
[V7|Tlv8] = Tlv7, 
Term7 = 'PKIX1Explicit-2009':'dec_SubjectPublicKeyInfo'(V7, [16]),

%%-------------------------------------------------
%% attribute issuerUniqueID(8) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term8,Tlv9} = case Tlv8 of
[{131073,V8}|TempTlv9] ->
    {decode_native_bit_string(V8, []), TempTlv9};
    _ ->
        { asn1_NOVALUE, Tlv8}
end,

%%-------------------------------------------------
%% attribute subjectUniqueID(9) with type BIT STRING OPTIONAL
%%-------------------------------------------------
{Term9,Tlv10} = case Tlv9 of
[{131074,V9}|TempTlv10] ->
    {decode_native_bit_string(V9, []), TempTlv10};
    _ ->
        { asn1_NOVALUE, Tlv9}
end,

%%-------------------------------------------------
%% attribute extensions(10) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term10,Tlv11} = case Tlv10 of
[{131075,V10}|TempTlv11] ->
    {'dec_OTPTBSCertificate_extensions'(V10, [16]), TempTlv11};
    _ ->
        { asn1_NOVALUE, Tlv10}
end,
Tlv12 = skip_ExtensionAdditions(Tlv11, []),

case Tlv12 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv12}}}) % extra fields not allowed
end,
Res1 = {'OTPTBSCertificate',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10},
Res1.
'dec_OTPTBSCertificate_signature'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'OTP-PKIX':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPTBSCertificate_signature',Term1,Term2},
Res1.
'dec_OTPTBSCertificate_extensions'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OTPTBSCertificate_extensions_Extension'(V1, [16]) || V1 <- Tlv1].


'dec_OTPTBSCertificate_extensions_Extension'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'Extension',Term1,Term2,Term3},
Res1.


%%================================
%%  OTP-DSA-Params-Or-NULL
%%================================
'enc_OTP-DSA-Params-Or-NULL'(Val) ->
    'enc_OTP-DSA-Params-Or-NULL'(Val, []).

'enc_OTP-DSA-Params-Or-NULL'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      present ->
         'PKIXAlgs-2009':'enc_DSA-Params'(element(2,Val), [<<48>>]);
      absent ->
         encode_null(element(2,Val), [<<5>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_OTP-DSA-Params-Or-NULL'(Tlv) ->
   'dec_OTP-DSA-Params-Or-NULL'(Tlv, []).

'dec_OTP-DSA-Params-Or-NULL'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'present'
    {16, V1} -> 
        {present, 'PKIXAlgs-2009':'dec_DSA-Params'(V1, [])};


%% 'absent'
    {5, V1} -> 
        {absent, decode_null(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OTPName
%%================================
enc_OTPName(Val) ->
    enc_OTPName(Val, []).

enc_OTPName(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      rdnSequence ->
         'enc_RDNSequence'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_OTPName(Tlv) ->
   dec_OTPName(Tlv, []).

dec_OTPName(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'rdnSequence'
    {16, V1} -> 
        {rdnSequence, 'dec_RDNSequence'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  RDNSequence
%%================================
enc_RDNSequence(Val) ->
    enc_RDNSequence(Val, [<<48>>]).

enc_RDNSequence(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_RDNSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_RDNSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_RDNSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OTPRelativeDistinguishedName'(H, [<<49>>]),
   'enc_RDNSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_RDNSequence(Tlv) ->
   dec_RDNSequence(Tlv, [16]).

dec_RDNSequence(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OTPRelativeDistinguishedName'(V1, [17]) || V1 <- Tlv1].




%%================================
%%  OTPRelativeDistinguishedName
%%================================
enc_OTPRelativeDistinguishedName(Val) ->
    enc_OTPRelativeDistinguishedName(Val, [<<49>>]).

enc_OTPRelativeDistinguishedName(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OTPRelativeDistinguishedName_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPRelativeDistinguishedName_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_OTPRelativeDistinguishedName_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OTPRelativeDistinguishedName_SingleAttribute'(H, [<<48>>]),
   'enc_OTPRelativeDistinguishedName_components'(T,[EncBytes|AccBytes], AccLen + EncLen).




%%================================
%%  OTPRelativeDistinguishedName_SingleAttribute
%%================================
enc_OTPRelativeDistinguishedName_SingleAttribute(Val, TagIn) ->
   {_,Cindex1,Cindex2} = Val,
Objtype = 
   'OTP-PKIX':'getenc_internal_object_set_argument_3'(                                   Cindex1),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = Objtype('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPRelativeDistinguishedName(Tlv) ->
   dec_OTPRelativeDistinguishedName(Tlv, [17]).

dec_OTPRelativeDistinguishedName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OTPRelativeDistinguishedName_SingleAttribute'(V1, [16]) || V1 <- Tlv1].


'dec_OTPRelativeDistinguishedName_SingleAttribute'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjtypeTerm1 =
   'OTP-PKIX':'getdec_internal_object_set_argument_3'(Term1),
Term2 = 
   case (catch DecObjtypeTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'SingleAttribute',Term1,Term2},
Res1.


%%================================
%%  OTP-X520countryName
%%================================
'enc_OTP-X520countryName'(Val) ->
    'enc_OTP-X520countryName'(Val, []).

'enc_OTP-X520countryName'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      correct ->
         encode_restricted_string(element(2,Val), [<<19>>]);
      wrong ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_OTP-X520countryName'(Tlv) ->
   'dec_OTP-X520countryName'(Tlv, []).

'dec_OTP-X520countryName'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'correct'
    {19, V1} -> 
        {correct, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 2 =< C1, C1 =< 3 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'wrong'
    {12, V1} -> 
        {wrong, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  OTP-emailAddress
%%================================
'enc_OTP-emailAddress'(Val) ->
    'enc_OTP-emailAddress'(Val, []).

'enc_OTP-emailAddress'(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      correct ->
         encode_restricted_string(element(2,Val), [<<22>>]);
      wrong ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_OTP-emailAddress'(Tlv) ->
   'dec_OTP-emailAddress'(Tlv, []).

'dec_OTP-emailAddress'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'correct'
    {22, V1} -> 
        {correct, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 255 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'wrong'
    {12, V1} -> 
        {wrong, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  HashSingleAttribute
%%================================
enc_HashSingleAttribute(Val) ->
    enc_HashSingleAttribute(Val, [<<48>>]).

enc_HashSingleAttribute(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute value(2) with type UTF8String
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_UTF8_string(Cindex2, [<<12>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_HashSingleAttribute(Tlv) ->
   dec_HashSingleAttribute(Tlv, [16]).

dec_HashSingleAttribute(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute type(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute value(2) with type UTF8String
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_UTF8_string(V2, [12]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'HashSingleAttribute',Term1,Term2},
Res1.


%%================================
%%  HashRDNSequence
%%================================
enc_HashRDNSequence(Val) ->
    enc_HashRDNSequence(Val, [<<48>>]).

enc_HashRDNSequence(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_HashRDNSequence_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_HashRDNSequence_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_HashRDNSequence_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_HashRelativeDistinguishedName'(H, [<<49>>]),
   'enc_HashRDNSequence_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_HashRDNSequence(Tlv) ->
   dec_HashRDNSequence(Tlv, [16]).

dec_HashRDNSequence(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_HashRelativeDistinguishedName'(V1, [17]) || V1 <- Tlv1].




%%================================
%%  HashRelativeDistinguishedName
%%================================
enc_HashRelativeDistinguishedName(Val) ->
    enc_HashRelativeDistinguishedName(Val, [<<49>>]).

enc_HashRelativeDistinguishedName(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_HashRelativeDistinguishedName_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_HashRelativeDistinguishedName_components'([], AccBytes, AccLen) -> 
   {dynamicsort_SETOF(AccBytes),AccLen};

'enc_HashRelativeDistinguishedName_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_HashSingleAttribute'(H, [<<48>>]),
   'enc_HashRelativeDistinguishedName_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_HashRelativeDistinguishedName(Tlv) ->
   dec_HashRelativeDistinguishedName(Tlv, [17]).

dec_HashRelativeDistinguishedName(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_HashSingleAttribute'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OTPCertificatePolicies
%%================================
enc_OTPCertificatePolicies(Val) ->
    enc_OTPCertificatePolicies(Val, [<<48>>]).

enc_OTPCertificatePolicies(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_OTPCertificatePolicies_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPCertificatePolicies_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OTPCertificatePolicies_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OTPPolicyInformation'(H, [<<48>>]),
   'enc_OTPCertificatePolicies_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OTPCertificatePolicies(Tlv) ->
   dec_OTPCertificatePolicies(Tlv, [16]).

dec_OTPCertificatePolicies(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OTPPolicyInformation'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OTPPolicyInformation
%%================================
enc_OTPPolicyInformation(Val) ->
    enc_OTPPolicyInformation(Val, [<<48>>]).

enc_OTPPolicyInformation(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OTPPolicyInformation_policyQualifiers'(Cindex2, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  OTPPolicyInformation_policyQualifiers
%%================================
enc_OTPPolicyInformation_policyQualifiers(Val, TagIn) ->
      {EncBytes,EncLen} = 'enc_OTPPolicyInformation_policyQualifiers_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_OTPPolicyInformation_policyQualifiers_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_OTPPolicyInformation_policyQualifiers_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OTPPolicyQualifierInfo'(H, [<<48>>]),
   'enc_OTPPolicyInformation_policyQualifiers_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_OTPPolicyInformation(Tlv) ->
   dec_OTPPolicyInformation(Tlv, [16]).

dec_OTPPolicyInformation(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyIdentifier(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute policyQualifiers(2) with type SEQUENCE OF OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{16,V2}|TempTlv3] ->
    {'dec_OTPPolicyInformation_policyQualifiers'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPPolicyInformation',Term1,Term2},
Res1.
'dec_OTPPolicyInformation_policyQualifiers'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OTPPolicyQualifierInfo'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  CertPolicyId
%%================================
enc_CertPolicyId(Val) ->
    enc_CertPolicyId(Val, [<<6>>]).

enc_CertPolicyId(Val, TagIn) ->
encode_object_identifier(Val, TagIn).


dec_CertPolicyId(Tlv) ->
   dec_CertPolicyId(Tlv, [6]).

dec_CertPolicyId(Tlv, TagIn) ->
decode_object_identifier(Tlv, TagIn).



%%================================
%%  OTPPolicyQualifierInfo
%%================================
enc_OTPPolicyQualifierInfo(Val) ->
    enc_OTPPolicyQualifierInfo(Val, [<<48>>]).

enc_OTPPolicyQualifierInfo(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
ObjpolicyQualifierId = 
   'OTP-PKIX':'getenc_PolicyQualifierId'(                                   Cindex1),

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute qualifier(2) with type typefieldType
%%-------------------------------------------------
   {TmpBytes2,_} = ObjpolicyQualifierId('Type', Cindex2, []),
   {EncBytes2,EncLen2} = encode_open_type(TmpBytes2, [])
,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPPolicyQualifierInfo(Tlv) ->
   dec_OTPPolicyQualifierInfo(Tlv, [16]).

dec_OTPPolicyQualifierInfo(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute policyQualifierId(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute qualifier(2) with type typefieldType
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 

  Tmpterm1 = decode_open_type(V2, []),

DecObjpolicyQualifierIdTerm1 =
   'OTP-PKIX':'getdec_PolicyQualifierId'(Term1),
Term2 = 
   case (catch DecObjpolicyQualifierIdTerm1('Type', Tmpterm1, [])) of
      {'EXIT', Reason1} ->
         exit({'Type not compatible with table constraint',Reason1});
      Tmpterm2 ->
         Tmpterm2
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPPolicyQualifierInfo',Term1,Term2},
Res1.


%%================================
%%  CPSuri
%%================================
enc_CPSuri(Val) ->
    enc_CPSuri(Val, [<<22>>]).

enc_CPSuri(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CPSuri(Tlv) ->
   dec_CPSuri(Tlv, [22]).

dec_CPSuri(Tlv, TagIn) ->
begin
binary_to_list(decode_restricted_string(Tlv, TagIn))
end
.



%%================================
%%  OTPUserNotice
%%================================
enc_OTPUserNotice(Val) ->
    enc_OTPUserNotice(Val, [<<48>>]).

enc_OTPUserNotice(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute noticeRef(1)   External PKIX1Implicit-2009:NoticeReference OPTIONAL
%%-------------------------------------------------
   {EncBytes1,EncLen1} =  case Cindex1 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'PKIX1Implicit-2009':'enc_NoticeReference'(Cindex1, [<<48>>])
       end,

%%-------------------------------------------------
%% attribute explicitText(2)   External OTP-PKIX:OTPDisplayText OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            'enc_OTPDisplayText'(Cindex2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPUserNotice(Tlv) ->
   dec_OTPUserNotice(Tlv, [16]).

dec_OTPUserNotice(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute noticeRef(1)   External PKIX1Implicit-2009:NoticeReference OPTIONAL
%%-------------------------------------------------
{Term1,Tlv2} = case Tlv1 of
[{16,V1}|TempTlv2] ->
    {'PKIX1Implicit-2009':'dec_NoticeReference'(V1, []), TempTlv2};
    _ ->
        { asn1_NOVALUE, Tlv1}
end,

%%-------------------------------------------------
%% attribute explicitText(2)   External OTP-PKIX:OTPDisplayText OPTIONAL
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[V2 = {22,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
[V2 = {26,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
[V2 = {30,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
[V2 = {12,_}|TempTlv3] ->
    {'dec_OTPDisplayText'(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'OTPUserNotice',Term1,Term2},
Res1.


%%================================
%%  OTPDisplayText
%%================================
enc_OTPDisplayText(Val) ->
    enc_OTPDisplayText(Val, []).

enc_OTPDisplayText(Val, TagIn) ->
   {EncBytes,EncLen} = case element(1,Val) of
      ia5String ->
         encode_restricted_string(element(2,Val), [<<22>>]);
      visibleString ->
         encode_restricted_string(element(2,Val), [<<26>>]);
      bmpString ->
         encode_BMP_string(element(2,Val), [<<30>>]);
      utf8String ->
         encode_UTF8_string(element(2,Val), [<<12>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




dec_OTPDisplayText(Tlv) ->
   dec_OTPDisplayText(Tlv, []).

dec_OTPDisplayText(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'ia5String'
    {22, V1} -> 
        {ia5String, begin
Val1 = decode_restricted_string(V1, []),
C1 = byte_size(Val1),
if 1 =< C1, C1 =< 650 ->
binary_to_list(Val1);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'visibleString'
    {26, V1} -> 
        {visibleString, begin
Val2 = decode_restricted_string(V1, []),
C2 = byte_size(Val2),
if 1 =< C2, C2 =< 650 ->
binary_to_list(Val2);
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'bmpString'
    {30, V1} -> 
        {bmpString, begin
Val3 = decode_BMP_string(V1, []),
C3 = length(Val3),
if 1 =< C3, C3 =< 650 ->
Val3;
true ->
exit({error,{asn1,bad_range}})
end
end};


%% 'utf8String'
    {12, V1} -> 
        {utf8String, decode_UTF8_string(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.


%%================================
%%  Extensions
%%================================
enc_Extensions(Val) ->
    enc_Extensions(Val, [<<48>>]).

enc_Extensions(Val, TagIn) ->
   {EncBytes,EncLen} = 'enc_Extensions_components'(Val,[],0),
   encode_tags(TagIn, EncBytes, EncLen).

'enc_Extensions_components'([], AccBytes, AccLen) -> 
   {lists:reverse(AccBytes),AccLen};

'enc_Extensions_components'([H|T],AccBytes, AccLen) ->
   {EncBytes,EncLen} = 'enc_OTPExtension'(H, [<<48>>]),
   'enc_Extensions_components'(T,[EncBytes|AccBytes], AccLen + EncLen).



dec_Extensions(Tlv) ->
   dec_Extensions(Tlv, [16]).

dec_Extensions(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),
['dec_OTPExtension'(V1, [16]) || V1 <- Tlv1].




%%================================
%%  OTPExtension
%%================================
enc_OTPExtension(Val) ->
    enc_OTPExtension(Val, [<<48>>]).

enc_OTPExtension(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3} = Val,

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case is_default_2(Cindex2) of
true -> {[],0};
false ->
encode_boolean(Cindex2, [<<1>>])
       end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes3,EncLen3} = encode_restricted_string(Cindex3, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3],
LenSoFar = EncLen1 + EncLen2 + EncLen3,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_OTPExtension(Tlv) ->
   dec_OTPExtension(Tlv, [16]).

dec_OTPExtension(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute extnID(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute critical(2) with type BOOLEAN DEFAULT = false
%%-------------------------------------------------
{Term2,Tlv3} = case Tlv2 of
[{1,V2}|TempTlv3] ->
    {decode_boolean(V2, []), TempTlv3};
    _ ->
        {false,Tlv2}
end,

%%-------------------------------------------------
%% attribute extnValue(3) with type OCTET STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_octet_string(V3, [4]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OTPExtension',Term1,Term2,Term3},
Res1.



%%================================
%%  otp-sa-dsaWithSHA1
%%================================
'enc_otp-sa-dsaWithSHA1'('Value', Val, _RestPrimFieldName) ->
   'PKIXAlgs-2009':'enc_DSA-Sig-Value'(Val, [<<48>>]);
'enc_otp-sa-dsaWithSHA1'('Params', Val, _RestPrimFieldName) ->
   'enc_OTP-DSA-Params-Or-NULL'(Val, []);
'enc_otp-sa-dsaWithSHA1'(smimeCaps,  Val, [H|T]) ->
   'enc_otp-sa-dsaWithSHA1_smimeCaps'(H, Val, T).


'dec_otp-sa-dsaWithSHA1'('Value', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIXAlgs-2009':'dec_DSA-Sig-Value'(Tlv, [16]);
'dec_otp-sa-dsaWithSHA1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_OTP-DSA-Params-Or-NULL'(Tlv, []);
'dec_otp-sa-dsaWithSHA1'(smimeCaps, Bytes,[H|T]) ->
   'dec_otp-sa-dsaWithSHA1_smimeCaps'(H, Bytes, T).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  otp-at-x520countryName
%%================================
'enc_otp-at-x520countryName'('Type', Val, _RestPrimFieldName) ->
   'enc_OTP-X520countryName'(Val, []);
'enc_otp-at-x520countryName'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_otp-at-x520countryName'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_OTP-X520countryName'(Tlv, []);
'dec_otp-at-x520countryName'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  otp-at-emailAddress
%%================================
'enc_otp-at-emailAddress'('Type', Val, _RestPrimFieldName) ->
   'enc_OTP-emailAddress'(Val, []);
'enc_otp-at-emailAddress'('equality-match', _,_) ->
  exit({error,{'use of missing field in object', 'equality-match'}}).


'dec_otp-at-emailAddress'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_OTP-emailAddress'(Tlv, []);
'dec_otp-at-emailAddress'('equality-match', _,_) ->
  exit({error,{'illegal use of missing field in object', 'equality-match'}}).




%%================================
%%  pqid-cps
%%================================
'enc_pqid-cps'('Type', Val, _RestPrimFieldName) ->
   enc_CPSuri(Val, [<<22>>]).


'dec_pqid-cps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_CPSuri(Tlv, [22]).




%%================================
%%  pqid-unotice
%%================================
'enc_pqid-unotice'('Type', Val, _RestPrimFieldName) ->
   enc_OTPUserNotice(Val, [<<48>>]).


'dec_pqid-unotice'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_OTPUserNotice(Tlv, [16]).




%%================================
%%  otp-sa-dsaWithSHA1_smimeCaps
%%================================
'enc_otp-sa-dsaWithSHA1_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_otp-sa-dsaWithSHA1_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  OTPTBSCertificate_smimeCaps
%%================================
enc_OTPTBSCertificate_smimeCaps('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


dec_OTPTBSCertificate_smimeCaps('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  OTPCertificate_smimeCaps
%%================================
enc_OTPCertificate_smimeCaps('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


dec_OTPCertificate_smimeCaps('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  OTPSignatureAlgorithms
%%================================
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'enc_otp-sa-dsaWithSHA1'/3;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_OTPSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_OTPSignatureAlgorithms(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'dec_otp-sa-dsaWithSHA1'/3;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_OTPSignatureAlgorithms(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_OTPSignatureAlgorithms(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  OTPSignatureAlgs
%%================================
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'enc_otp-sa-dsaWithSHA1'/3;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_OTPSignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_OTPSignatureAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'dec_otp-sa-dsaWithSHA1'/3;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_OTPSignatureAlgs(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_OTPSignatureAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  OTPSupportedAttributes
%%================================
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,3} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520CommonName'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,4} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-surname'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,5} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520SerialNumber'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,6} ->
    fun 'enc_otp-at-x520countryName'/3;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,7} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520LocalityName'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,8} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520StateOrProvinceName'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,10} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520OrganizationName'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,11} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520OrganizationalUnitName'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,12} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520Title'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,41} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-name'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,42} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-givenName'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,43} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-initials'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,44} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-generationQualifier'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,46} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520dnQualifier'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {2,5,4,65} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520Pseudonym'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-domainComponent'(T,V,O) end;
getenc_OTPSupportedAttributes(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'enc_otp-at-emailAddress'/3;
getenc_OTPSupportedAttributes(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,3} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520CommonName'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,4} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-surname'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,5} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520SerialNumber'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,6} ->
    fun 'dec_otp-at-x520countryName'/3;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,7} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520LocalityName'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,8} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520StateOrProvinceName'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,10} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520OrganizationName'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,11} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520OrganizationalUnitName'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,12} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520Title'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,41} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-name'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,42} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-givenName'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,43} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-initials'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,44} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-generationQualifier'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,46} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520dnQualifier'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {2,5,4,65} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520Pseudonym'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-domainComponent'(T,V,O) end;
getdec_OTPSupportedAttributes(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'dec_otp-at-emailAddress'/3;
getdec_OTPSupportedAttributes(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PolicyQualifierId
%%================================
getenc_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,1} ->
    fun 'enc_pqid-cps'/3;
getenc_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,2} ->
    fun 'enc_pqid-unotice'/3;
getenc_PolicyQualifierId(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,1} ->
    fun 'dec_pqid-cps'/3;
getdec_PolicyQualifierId(Id) when Id =:= {1,3,6,1,5,5,7,2,2} ->
    fun 'dec_pqid-unotice'/3;
getdec_PolicyQualifierId(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_9
%%================================
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'enc_otp-sa-dsaWithSHA1'/3;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_9(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_9(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'dec_otp-sa-dsaWithSHA1'/3;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_9(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_9(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_7
%%================================
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_7(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_7(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_7(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectDirectoryAttributes'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-KeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectAltName'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-IssuerAltName'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-BasicConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-NameConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CRLDistributionPoints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-CertificatePolicies'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyMappings'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityKeyIdentifier'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-PolicyConstraints'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-ExtKeyUsage'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-FreshestCRL'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-InhibitAnyPolicy'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-AuthorityInfoAccess'(T,V,O) end;
getenc_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'enc_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,9} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectDirectoryAttributes'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,14} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,15} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-KeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,16} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PrivateKeyUsagePeriod'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,17} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectAltName'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,18} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-IssuerAltName'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,19} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-BasicConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,30} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-NameConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,31} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CRLDistributionPoints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,32} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-CertificatePolicies'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,33} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyMappings'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,35} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityKeyIdentifier'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,36} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-PolicyConstraints'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,37} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-ExtKeyUsage'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,46} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-FreshestCRL'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {2,5,29,54} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-InhibitAnyPolicy'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,1} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-AuthorityInfoAccess'(T,V,O) end;
getdec_internal_object_set_argument_6(Id) when Id =:= {1,3,6,1,5,5,7,1,11} ->
   fun(T,V,O) -> 'PKIX1Implicit-2009':'dec_ext-SubjectInfoAccessSyntax'(T,V,O) end;
getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_3
%%================================
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,3} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520CommonName'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,4} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-surname'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,5} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520SerialNumber'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,6} ->
    fun 'enc_otp-at-x520countryName'/3;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,7} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520LocalityName'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,8} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520StateOrProvinceName'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,10} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520OrganizationName'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,11} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520OrganizationalUnitName'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,12} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520Title'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,41} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-name'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,42} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-givenName'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,43} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-initials'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,44} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-generationQualifier'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,46} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520dnQualifier'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {2,5,4,65} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-x520Pseudonym'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'enc_at-domainComponent'(T,V,O) end;
getenc_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'enc_otp-at-emailAddress'/3;
getenc_internal_object_set_argument_3(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,3} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520CommonName'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,4} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-surname'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,5} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520SerialNumber'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,6} ->
    fun 'dec_otp-at-x520countryName'/3;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,7} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520LocalityName'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,8} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520StateOrProvinceName'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,10} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520OrganizationName'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,11} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520OrganizationalUnitName'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,12} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520Title'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,41} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-name'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,42} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-givenName'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,43} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-initials'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,44} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-generationQualifier'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,46} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520dnQualifier'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {2,5,4,65} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-x520Pseudonym'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {0,9,2342,19200300,100,1,25} ->
   fun(T,V,O) -> 'PKIX1Explicit-2009':'dec_at-domainComponent'(T,V,O) end;
getdec_internal_object_set_argument_3(Id) when Id =:= {1,2,840,113549,1,9,1} ->
    fun 'dec_otp-at-emailAddress'/3;
getdec_internal_object_set_argument_3(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'enc_otp-sa-dsaWithSHA1'/3;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA384'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-ecdsaWithSHA512'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD2'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithMD5'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-rsaWithSHA1'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'enc_sa-rsaSSA-PSS'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA224'(T,V,O) end;
getenc_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_sa-dsaWithSHA256'(T,V,O) end;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10040,4,3} ->
    fun 'dec_otp-sa-dsaWithSHA1'/3;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,3} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA384'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,10045,4,3,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-ecdsaWithSHA512'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD2'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,4} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithMD5'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,5} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-rsaWithSHA1'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,1,10} ->
   fun(T,V,O) -> 'PKIX1-PSS-OAEP-Algorithms-2009':'dec_sa-rsaSSA-PSS'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA224'(T,V,O) end;
getdec_internal_object_set_argument_2(Id) when Id =:= {2,16,840,1,101,3,4,3,2} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_sa-dsaWithSHA256'(T,V,O) end;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.




'dec-inc-OTPCertificate'(Tlv) ->
   'dec-inc-OTPCertificate'(Tlv, [16]).

'dec-inc-OTPCertificate'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute tbsCertificate(1)   External OTP-PKIX:OTPTBSCertificate
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = {'OTPCertificate_tbsCertificate',V1},

%%-------------------------------------------------
%% attribute signatureAlgorithm(2) with type SEQUENCE
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = 'dec_OTPCertificate_signatureAlgorithm'(V2, [16]),

%%-------------------------------------------------
%% attribute signature(3) with type BIT STRING
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = decode_native_bit_string(V3, [3]),

case Tlv4 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv4}}}) % extra fields not allowed
end,
Res1 = {'OTPCertificate',Term1,Term2,Term3},
Res1.
decode_TBSCert_exclusive(Bytes) ->
  decode_partial_incomplete('OTPCertificate', Bytes, [mandatory,{undecoded,[16]}]).
decode_inc_disp('OTPCertificate_tbsCertificate',Data) ->
  'dec_OTPTBSCertificate'(Data,[16]).

%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    _ = decode_primitive_incomplete([{undecoded,0},{alt_parts,0}], element(6, Arg)),
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try check_int(Value, 0, [{v1,0},{v2,1},{v3,2}]) of
_ -> true
catch throw:false -> false
end.


is_default_2(asn1_DEFAULT) ->
true;
is_default_2(Def) when Def =:= false ->
true;
is_default_2(_) ->
false.


ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_int(Value, Value, _) when is_integer(Value) ->
    true;
check_int(Value, DefValue, NNL) when is_atom(Value) ->
    case lists:keyfind(Value, 1, NNL) of
        {_, DefValue} ->
            true;
        _ ->
            throw(false)
    end;
check_int(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_BMP_string(Buffer, Tags) ->
    Bin = match_and_collect(Buffer, Tags),
    mk_BMP_string(binary_to_list(Bin)).

decode_UTF8_string(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin ->
            Bin
    end.

decode_boolean(Tlv, TagIn) ->
    Val = match_tags(Tlv, TagIn),
    case Val of
        <<0:8>> ->
            false;
        <<_:8>> ->
            true;
        _ ->
            exit({error, {asn1, {decode_boolean, Val}}})
    end.

decode_constr_indef_incomplete(_TagMatch, <<0,0,Rest/binary>>, Acc) ->
    {lists:reverse(Acc), Rest};
decode_constr_indef_incomplete([Tag | RestTags], Bin, Acc) ->
    case decode_primitive_incomplete([Tag], Bin) of
        {Tlv, Rest} ->
            decode_constr_indef_incomplete(RestTags, Rest, [Tlv | Acc]);
        asn1_NOVALUE ->
            decode_constr_indef_incomplete(RestTags, Bin, Acc)
    end.

decode_constructed(Bin) when byte_size(Bin) =:= 0 ->
    [];
decode_constructed(Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed(Rest)].

decode_constructed_incomplete([Tags = [Ts]], Bin) when is_list(Ts) ->
    decode_constructed_incomplete(Tags, Bin);
decode_constructed_incomplete(_TagMatch, <<>>) ->
    [];
decode_constructed_incomplete([mandatory | RestTag], Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed_incomplete(RestTag, Rest)];
decode_constructed_incomplete([{Alt, _} | _] = Directives, Bin)
    when Alt =:= alt_undecoded; Alt =:= alt; Alt =:= alt_parts ->
    {_Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    case incomplete_choice_alt(TagNo, Directives) of
        {alt_undecoded, _} ->
            LenA = byte_size(Bin) - byte_size(Rest),
            <<A:LenA/binary,Rest/binary>> = Bin,
            A;
        {alt, InnerDirectives} ->
            {Tlv, Rest} =
                decode_primitive_incomplete(InnerDirectives, V),
            {TagNo, Tlv};
        {alt_parts, _} ->
            [{TagNo, decode_parts_incomplete(V)}];
        no_match ->
            {Tlv, _} = decode_primitive(Bin),
            Tlv
    end;
decode_constructed_incomplete([TagNo | RestTag], Bin) ->
    case decode_primitive_incomplete([TagNo], Bin) of
        {Tlv, Rest} ->
            [Tlv | decode_constructed_incomplete(RestTag, Rest)];
        asn1_NOVALUE ->
            decode_constructed_incomplete(RestTag, Bin)
    end;
decode_constructed_incomplete([], Bin) ->
    {Tlv, Rest} = decode_primitive(Bin),
    [Tlv | decode_constructed_incomplete([], Rest)].

decode_constructed_indefinite(<<0,0,Rest/binary>>, Acc) ->
    {lists:reverse(Acc), Rest};
decode_constructed_indefinite(Bin, Acc) ->
    {Tlv, Rest} = decode_primitive(Bin),
    decode_constructed_indefinite(Rest, [Tlv | Acc]).

decode_incomplete2(_Form = 2, TagNo, V, TagMatch, _) ->
    {Vlist, Rest2} = decode_constr_indef_incomplete(TagMatch, V, []),
    {{TagNo, Vlist}, Rest2};
decode_incomplete2(1, TagNo, V, [TagMatch], Rest) when is_list(TagMatch) ->
    {{TagNo, decode_constructed_incomplete(TagMatch, V)}, Rest};
decode_incomplete2(1, TagNo, V, TagMatch, Rest) ->
    {{TagNo, decode_constructed_incomplete(TagMatch, V)}, Rest};
decode_incomplete2(0, TagNo, V, _TagMatch, Rest) ->
    {{TagNo, V}, Rest}.

decode_incomplete_bin(Bin) ->
    {ok, Rest} = skip_tag(Bin),
    {ok, Rest2} = skip_length_and_value(Rest),
    IncLen = byte_size(Bin) - byte_size(Rest2),
    <<IncBin:IncLen/binary,Ret/binary>> = Bin,
    {IncBin, Ret}.

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_length(<<1:1,0:7,T/binary>>) ->
    {indefinite, T};
decode_length(<<0:1,Length:7,T/binary>>) ->
    {Length, T};
decode_length(<<1:1,LL:7,Length:LL/unit:8,T/binary>>) ->
    {Length, T}.

decode_native_bit_string(Buffer, Tags) ->
    case match_and_collect(Buffer, Tags) of
        <<0>> ->
            <<>>;
        <<Unused,Bits/binary>> ->
            Size = bit_size(Bits) - Unused,
            <<Val:Size/bitstring,_:Unused/bitstring>> = Bits,
            Val
    end.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

decode_parts_incomplete(<<>>) ->
    [];
decode_parts_incomplete(Bin) ->
    {ok, Rest} = skip_tag(Bin),
    {ok, Rest2} = skip_length_and_value(Rest),
    LenPart = byte_size(Bin) - byte_size(Rest2),
    <<Part:LenPart/binary,RestBin/binary>> = Bin,
    [Part | decode_parts_incomplete(RestBin)].

decode_primitive(Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    case Form of
        1 ->
            {{TagNo, decode_constructed(V)}, Rest};
        0 ->
            {{TagNo, V}, Rest};
        2 ->
            {Vlist, Rest2} = decode_constructed_indefinite(V, []),
            {{TagNo, Vlist}, Rest2}
    end.

decode_primitive_incomplete([{default, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, [], Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{default, TagNo, Directives}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{default_undecoded, [Tag | _]}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, Tag, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, [], Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt, TagNo, Directives}], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{opt_undecoded, [Tag | _]}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, Tag, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{alt_undecoded, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_, TagNo, _, _} ->
            decode_incomplete_bin(Bin);
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, V}, Rest};
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt, TagNo, Directives} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {Form, TagNo, V, Rest} ->
            decode_incomplete2(Form, TagNo, V, Directives, Rest);
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{alt_parts, TagNo}], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, V}, Rest};
        _ ->
            asn1_NOVALUE
    end;
decode_primitive_incomplete([{alt_parts, TagNo} | RestAlts], Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            {{TagNo, decode_parts_incomplete(V)}, Rest};
        _ ->
            decode_primitive_incomplete(RestAlts, Bin)
    end;
decode_primitive_incomplete([{undecoded, _TagNo} | _RestTag], Bin) ->
    decode_incomplete_bin(Bin);
decode_primitive_incomplete([{parts, [TagNo | MoreTags]} | _RestTag],
                            Bin) ->
    case decode_tag_and_length(Bin) of
        {_Form, TagNo, V, Rest} ->
            case MoreTags of
                [] ->
                    {{TagNo, decode_parts_incomplete(V)}, Rest};
                [TagNo2] ->
                    {_, TagNo2, V2, <<>>} = decode_tag_and_length(V),
                    {{TagNo, {TagNo2, decode_parts_incomplete(V2)}},
                     Rest}
            end;
        Err ->
            {error, {asn1, "tag failure", TagNo, Err}}
    end;
decode_primitive_incomplete([mandatory | RestTag], Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    decode_incomplete2(Form, TagNo, V, RestTag, Rest);
decode_primitive_incomplete([{mandatory, Directives}], Bin) ->
    {Form, TagNo, V, Rest} = decode_tag_and_length(Bin),
    decode_incomplete2(Form, TagNo, V, Directives, Rest);
decode_primitive_incomplete([], Bin) ->
    decode_primitive(Bin).

decode_restricted_string(Tlv, TagsIn) ->
    match_and_collect(Tlv, TagsIn).

decode_tag(<<0:1,PartialTag:7,Buffer/binary>>, TagAck) ->
    TagNo = TagAck bsl 7 bor PartialTag,
    {TagNo, Buffer};
decode_tag(<<_:1,PartialTag:7,Buffer/binary>>, TagAck) ->
    TagAck1 = TagAck bsl 7 bor PartialTag,
    decode_tag(Buffer, TagAck1).

decode_tag_and_length(<<Class:2,
                        Form:1,
                        TagNo:5,
                        0:1,
                        Length:7,
                        V:Length/binary,
                        RestBuffer/binary>>)
    when TagNo < 31 ->
    {Form, Class bsl 16 bor TagNo, V, RestBuffer};
decode_tag_and_length(<<Class:2,1:1,TagNo:5,1:1,0:7,T/binary>>)
    when TagNo < 31 ->
    {2, Class bsl 16 + TagNo, T, <<>>};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        TagNo:5,
                        1:1,
                        LL:7,
                        Length:LL/unit:8,
                        V:Length/binary,
                        T/binary>>)
    when TagNo < 31 ->
    {Form, Class bsl 16 bor TagNo, V, T};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        0:1,
                        TagNo:7,
                        0:1,
                        Length:7,
                        V:Length/binary,
                        RestBuffer/binary>>) ->
    {Form, Class bsl 16 bor TagNo, V, RestBuffer};
decode_tag_and_length(<<Class:2,1:1,31:5,0:1,TagNo:7,1:1,0:7,T/binary>>) ->
    {2, Class bsl 16 bor TagNo, T, <<>>};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        0:1,
                        TagNo:7,
                        1:1,
                        LL:7,
                        Length:LL/unit:8,
                        V:Length/binary,
                        T/binary>>) ->
    {Form, Class bsl 16 bor TagNo, V, T};
decode_tag_and_length(<<Class:2,
                        Form:1,
                        31:5,
                        1:1,
                        TagPart1:7,
                        0:1,
                        TagPartLast,
                        Buffer/binary>>) ->
    TagNo = TagPart1 bsl 7 bor TagPartLast,
    {Length, RestBuffer} = decode_length(Buffer),
    <<V:Length/binary,RestBuffer2/binary>> = RestBuffer,
    {Form, Class bsl 16 bor TagNo, V, RestBuffer2};
decode_tag_and_length(<<Class:2,Form:1,31:5,Buffer/binary>>) ->
    {TagNo, Buffer1} = decode_tag(Buffer, 0),
    {Length, RestBuffer} = decode_length(Buffer1),
    <<V:Length/binary,RestBuffer2/binary>> = RestBuffer,
    {Form, Class bsl 16 bor TagNo, V, RestBuffer2}.

dynamicsort_SETOF(ListOfEncVal) ->
    BinL =
        lists:map(fun(L) when is_list(L) ->
                         list_to_binary(L);
                     (B) ->
                         B
                  end,
                  ListOfEncVal),
    lists:sort(BinL).

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_BMP_string(BMPString, TagIn) ->
    OctetList = mk_BMP_list(BMPString),
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_UTF8_string(UTF8String, TagIn) when is_binary(UTF8String) ->
    encode_tags(TagIn, UTF8String, byte_size(UTF8String));
encode_UTF8_string(UTF8String, TagIn) ->
    encode_tags(TagIn, UTF8String, length(UTF8String)).

encode_boolean(true, TagIn) ->
    encode_tags(TagIn, [255], 1);
encode_boolean(false, TagIn) ->
    encode_tags(TagIn, [0], 1);
encode_boolean(X, _) ->
    exit({error, {asn1, {encode_boolean, X}}}).

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, NamedNumberList, Tag) when is_atom(Val) ->
    case lists:keyfind(Val, 1, NamedNumberList) of
        {_, NewVal} ->
            encode_tags(Tag, encode_integer(NewVal));
        _ ->
            exit({error, {asn1, {encode_integer_namednumber, Val}}})
    end;
encode_integer(Val, _NamedNumberList, Tag) ->
    encode_tags(Tag, encode_integer(Val)).

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

encode_unnamed_bit_string(Bits, TagIn) ->
    Unused = (8 - bit_size(Bits) band 7) band 7,
    Bin = <<Unused,Bits/bitstring,0:Unused>>,
    encode_tags(TagIn, Bin, byte_size(Bin)).

incomplete_choice_alt(TagNo, [{Alt, TagNo} | Directives]) ->
    {Alt, Directives};
incomplete_choice_alt(TagNo, [D]) when is_list(D) ->
    incomplete_choice_alt(TagNo, D);
incomplete_choice_alt(TagNo, [_H | Directives]) ->
    incomplete_choice_alt(TagNo, Directives);
incomplete_choice_alt(_, []) ->
    no_match.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_BMP_list(In) ->
    mk_BMP_list(In, []).

mk_BMP_list([], List) ->
    lists:reverse(List);
mk_BMP_list([{0, 0, C, D} | T], List) ->
    mk_BMP_list(T, [D, C | List]);
mk_BMP_list([H | T], List) ->
    mk_BMP_list(T, [H, 0 | List]).

mk_BMP_string(In) ->
    mk_BMP_string(In, []).

mk_BMP_string([], US) ->
    lists:reverse(US);
mk_BMP_string([0, B | T], US) ->
    mk_BMP_string(T, [B | US]);
mk_BMP_string([C, D | T], US) ->
    mk_BMP_string(T, [{0, 0, C, D} | US]).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).

number2name(Int, NamedNumberList) ->
    case lists:keyfind(Int, 2, NamedNumberList) of
        {NamedVal, _} ->
            NamedVal;
        _ ->
            Int
    end.

skip_ExtensionAdditions([], _Tags) ->
    [];
skip_ExtensionAdditions([{Tag, _} | Rest] = TLV, Tags) ->
    case
        [ 
         X ||
             X = T <- Tags,
             T =:= Tag
        ]
    of
        [] ->
            skip_ExtensionAdditions(Rest, Tags);
        _ ->
            TLV
    end.

skip_indefinite_value(<<0,0,Rest/binary>>) ->
    {ok, Rest};
skip_indefinite_value(Binary) ->
    {ok, RestBinary} = skip_tag(Binary),
    {ok, RestBinary2} = skip_length_and_value(RestBinary),
    skip_indefinite_value(RestBinary2).

skip_length_and_value(Binary) ->
    case decode_length(Binary) of
        {indefinite, RestBinary} ->
            skip_indefinite_value(RestBinary);
        {Length, RestBinary} ->
            <<_:Length/unit:8,Rest/binary>> = RestBinary,
            {ok, Rest}
    end.

skip_long_tag(<<1:1,_:7,Rest/binary>>) ->
    skip_long_tag(Rest);
skip_long_tag(<<0:1,_:7,Rest/binary>>) ->
    {ok, Rest}.

skip_tag(<<_:3,31:5,Rest/binary>>) ->
    skip_long_tag(Rest);
skip_tag(<<_:3,_Tag:5,Rest/binary>>) ->
    {ok, Rest}.
