# This file has been autogenerated by the pywayland scanner

# Copyright © 2021-2023 Andri Yngvason
# Copyright © 2024 Simon Ser
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .ext_image_copy_capture_session_v1 import ExtImageCopyCaptureSessionV1


class ExtImageCopyCaptureCursorSessionV1(Interface):
    """Cursor capture session

    This object represents a cursor capture session. It extends the base
    capture session with cursor-specific metadata.
    """

    name = "ext_image_copy_capture_cursor_session_v1"
    version = 1

    class error(enum.IntEnum):
        duplicate_session = 1


class ExtImageCopyCaptureCursorSessionV1Proxy(Proxy[ExtImageCopyCaptureCursorSessionV1]):
    interface = ExtImageCopyCaptureCursorSessionV1

    @ExtImageCopyCaptureCursorSessionV1.request()
    def destroy(self) -> None:
        """Delete this object

        Destroys the session. This request can be sent at any time by the
        client.

        This request doesn't affect
        :class:`~pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureFrameV1`
        objects created by this object.
        """
        self._marshal(0)
        self._destroy()

    @ExtImageCopyCaptureCursorSessionV1.request(
        Argument(ArgumentType.NewId, interface=ExtImageCopyCaptureSessionV1),
    )
    def get_capture_session(self) -> Proxy[ExtImageCopyCaptureSessionV1]:
        """Get image copy captuerer session

        Gets the image copy capture session for this cursor session.

        The session will produce frames of the cursor image. The compositor may
        pause the session when the cursor leaves the captured area.

        This request must not be sent more than once, or else the
        duplicate_session protocol error is raised.

        :returns:
            :class:`~pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureSessionV1`
        """
        session = self._marshal_constructor(1, ExtImageCopyCaptureSessionV1)
        return session


class ExtImageCopyCaptureCursorSessionV1Resource(Resource):
    interface = ExtImageCopyCaptureCursorSessionV1

    @ExtImageCopyCaptureCursorSessionV1.event()
    def enter(self) -> None:
        """Cursor entered captured area

        Sent when a cursor enters the captured area. It shall be generated
        before the "position" and "hotspot" events when and only when a cursor
        enters the area.

        The cursor enters the captured area when the cursor image intersects
        with the captured area. Note, this is different from e.g.
        :func:`WlPointer.enter() <pywayland.protocol.wayland.WlPointer.enter>`.
        """
        self._post_event(0)

    @ExtImageCopyCaptureCursorSessionV1.event()
    def leave(self) -> None:
        """Cursor left captured area

        Sent when a cursor leaves the captured area. No "position" or "hotspot"
        event is generated for the cursor until the cursor enters the captured
        area again.
        """
        self._post_event(1)

    @ExtImageCopyCaptureCursorSessionV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def position(self, x: int, y: int) -> None:
        """Position changed

        Cursors outside the image capture source do not get captured and no
        event will be generated for them.

        The given position is the position of the cursor's hotspot and it is
        relative to the main buffer's top left corner in transformed buffer
        pixel coordinates. The coordinates may be negative or greater than the
        main buffer size.

        :param x:
            position x coordinates
        :type x:
            `ArgumentType.Int`
        :param y:
            position y coordinates
        :type y:
            `ArgumentType.Int`
        """
        self._post_event(2, x, y)

    @ExtImageCopyCaptureCursorSessionV1.event(
        Argument(ArgumentType.Int),
        Argument(ArgumentType.Int),
    )
    def hotspot(self, x: int, y: int) -> None:
        """Hotspot changed

        The hotspot describes the offset between the cursor image and the
        position of the input device.

        The given coordinates are the hotspot's offset from the origin in
        buffer coordinates.

        Clients should not apply the hotspot immediately: the hotspot becomes
        effective when the next :func:`ExtImageCopyCaptureFrameV1.ready()
        <pywayland.protocol.ext_image_copy_capture_v1.ExtImageCopyCaptureFrameV1.ready>`
        event is received.

        Compositors may delay this event until the client captures a new frame.

        :param x:
            hotspot x coordinates
        :type x:
            `ArgumentType.Int`
        :param y:
            hotspot y coordinates
        :type y:
            `ArgumentType.Int`
        """
        self._post_event(3, x, y)


class ExtImageCopyCaptureCursorSessionV1Global(Global):
    interface = ExtImageCopyCaptureCursorSessionV1


ExtImageCopyCaptureCursorSessionV1._gen_c()
ExtImageCopyCaptureCursorSessionV1.proxy_class = ExtImageCopyCaptureCursorSessionV1Proxy
ExtImageCopyCaptureCursorSessionV1.resource_class = ExtImageCopyCaptureCursorSessionV1Resource
ExtImageCopyCaptureCursorSessionV1.global_class = ExtImageCopyCaptureCursorSessionV1Global
