# shared.py.in
#
# Copyright 2022-2023 kramo
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-or-later

from enum import IntEnum, auto
from os import getenv
from pathlib import Path

from gi.repository import Gdk, Gio, GLib


class AppState(IntEnum):
    DEFAULT = auto()
    LOAD_FROM_DISK = auto()
    IMPORT = auto()
    REMOVE_ALL_GAMES = auto()
    UNDO_REMOVE_ALL_GAMES = auto()


APP_ID = "page.kramo.Cartridges"
VERSION = "2.12.1"
PREFIX = "/page/kramo/Cartridges"
PROFILE = "release"
TIFF_COMPRESSION = "webp"
SPEC_VERSION = 1.5  # The version of the game_id.json spec

schema = Gio.Settings.new(APP_ID)
state_schema = Gio.Settings.new(APP_ID + ".State")

home = Path.home()

data_dir = Path(GLib.get_user_data_dir())
host_data_dir = Path(getenv("HOST_XDG_DATA_HOME", Path.home() / ".local" / "share"))

config_dir = Path(GLib.get_user_config_dir())
host_config_dir = Path(getenv("HOST_XDG_CONFIG_HOME", Path.home() / ".config"))

cache_dir = Path(GLib.get_user_cache_dir())
host_cache_dir = Path(getenv("HOST_XDG_CACHE_HOME", Path.home() / ".cache"))

flatpak_dir = home / ".var" / "app"

games_dir = data_dir / "cartridges" / "games"
covers_dir = data_dir / "cartridges" / "covers"

appdata_dir = Path(getenv("appdata") or r"C:\Users\Default\AppData\Roaming")
local_appdata_dir = Path(
    getenv("csidl_local_appdata") or r"C:\Users\Default\AppData\Local"
)
programfiles32_dir = Path(getenv("programfiles(x86)") or r"C:\Program Files (x86)")

app_support_dir = home / "Library" / "Application Support"

try:
    scale_factor = max(
        monitor.get_scale_factor()
        for monitor in Gdk.Display.get_default().get_monitors()
    )
except AttributeError:  # If shared.py is imported by the search provider
    pass
else:
    image_size = (200 * scale_factor, 300 * scale_factor)

# pylint: disable=invalid-name
win = None
importer = None
import_time = None
store = None
log_files = []
