//go:generate re2go $INPUT -o $OUTPUT -i --header lexer/state.go
package main

import "./lexer" // the package is generated by re2c

/*!header:re2c:on*/
package lexer

type State struct {
	Data string
	Cur /*!stags:re2c format=", @@"; */ int
}
/*!header:re2c:off*/

func lex(st *lexer.State) int {
	var t int
	/*!re2c
		re2c:header = "lexer/state.go";
		re2c:yyfill:enable = 0;
		re2c:define:YYCTYPE  = byte;
		re2c:define:YYPEEK   = "st.Data[st.Cur]";
		re2c:define:YYSKIP   = "st.Cur++";
		re2c:define:YYSTAGP  = "@@ = st.Cur";
		re2c:tags            = 1;
		re2c:tags:expression = "st.@@";
		re2c:tags:prefix     = "Tag";

		[a]* @t [b]* { return t }
	*/
}

func main() {
	st := &lexer.State{Data:"ab\x00",}
	if lex(st) != 1 {
		panic("error")
	}
}
