/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.output.ErrorEmitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLParam;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class SAXONFunction
extends StyleElement {
    int functionFingerprint = -1;
    Procedure procedure = new Procedure();

    protected void processExtensionElementAttribute(int n) throws TransformerConfigurationException {
        short s;
        this.extensionNamespaces = new short[1];
        NamePool namePool = this.getNamePool();
        this.extensionNamespaces[0] = s = namePool.getURICode(this.getNameCode());
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.NAME) {
                string = attributeCollection.getValue(n);
                if (string.indexOf(58) < 0) {
                    this.compileError("Function name must have a namespace prefix");
                }
                try {
                    int n4 = this.makeNameCode(string, false);
                    this.functionFingerprint = n4 & 0xFFFFF;
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("name");
        }
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    public void preprocess() throws TransformerConfigurationException {
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
    }

    public void process(Context context) {
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public int getFunctionFingerprint() {
        if (this.functionFingerprint == -1) {
            try {
                this.prepareAttributes();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                return -1;
            }
        }
        return this.functionFingerprint;
    }

    public int getNthParameter(int n) {
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        int n2 = 0;
        while (nodeImpl != null) {
            if (nodeImpl instanceof XSLParam) {
                if (n2 == n) {
                    return ((XSLParam)nodeImpl).getVariableFingerprint();
                }
                ++n2;
            }
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
        return -1;
    }

    public Value call(ParameterSet parameterSet, Context context) throws TransformerException {
        Object object;
        Bindery bindery = context.getBindery();
        bindery.openStackFrame(parameterSet);
        Controller controller = context.getController();
        Outputter outputter = controller.getOutputter();
        controller.changeOutputDestination(null, new ErrorEmitter());
        if (controller.isTracing()) {
            object = controller.getTraceListener();
            object.enter(this, context);
            this.processChildren(context);
            object.leave(this, context);
        } else {
            this.processChildren(context);
        }
        controller.resetOutputDestination(outputter);
        bindery.closeStackFrame();
        object = context.getReturnValue();
        if (object == null) {
            object = new StringValue("");
        }
        context.setReturnValue(null);
        return object;
    }
}

